% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{read.names}
\alias{read.names}
\title{Read NCBI names file}
\usage{
read.names(nameFile, onlyScientific = TRUE)
}
\arguments{
\item{nameFile}{string giving the path to an NCBI name file to read from (both gzipped or uncompressed files are ok)}

\item{onlyScientific}{If TRUE, only store scientific names. If FALSE, synonyms and other types are included (increasing the potential for ambiguous taxonomic assignments).}
}
\value{
a data.table with columns id and name with a key on id
}
\description{
Take an NCBI names file, keep only scientific names and convert it to a data.table
}
\examples{
namesText<-c(
  "1\\t|\\tall\\t|\\t\\t|\\tsynonym\\t|",
  "1\\t|\\troot\\t|\\t\\t|\\tscientific name\\t|",
  "2\\t|\\tBacteria\\t|\\tBacteria <prokaryotes>\\t|\\tscientific name\\t|",
  "2\\t|\\tMonera\\t|\\tMonera <Bacteria>\\t|\\tin-part\\t|",
  "2\\t|\\tProcaryotae\\t|\\tProcaryotae <Bacteria>\\t|\\tin-part\\t|"
)
read.names(textConnection(namesText))
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/}
}
\seealso{
\code{\link{read.nodes}}
}
