% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_data}
\alias{filter_data}
\title{Filter rows}
\usage{
filter_data(.data, ...)
}
\arguments{
\item{.data}{Data frame or two dimensional array}

\item{...}{Each argument/expression should should evaluate and reduce down to
an integer (row number) or logical vector. The filter will keep all row
numbers that appear in all evaluated expressions (commas are the equivalent
to \code{&}. Row numbers higher than what exists in x will be ignored. Any
numeric vector must be either all positive or all negative (excludes). This
function uses non-standard evaluation–users can refer to column names
without quotations.}
}
\value{
Sliced/filtered data frame
}
\description{
Filter rows via integer/numeric position or logical vector
}
\examples{
set.seed(12)
d <- data.frame(
  mpg = rnorm(100, 25, 3),
  gear = sample(3:6, 100, replace = TRUE),
  vs = sample(0:1, 100, replace = TRUE),
  stringsAsFactors = FALSE
)

filter_data(d, mpg > 30)
filter_data(d, !mpg < 30)
filter_data(d, mpg > 30, !mpg < 30)
filter_data(d, mpg > 30, gear == 4)
filter_data(d, mpg > 30 | gear == 4, vs == 1)

}
