% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dataproc.R
\name{generate.tcr}
\alias{generate.tcr}
\title{Generate random nucleotide TCR sequences.}
\usage{
generate.tcr(.count = 1, .chain = c("beta", "alpha"),
  .segments = segments, .P.list = if (.chain[1] == "alpha") alpha.prob else
  beta.prob)
}
\arguments{
\item{.count}{Number of TCR sequences to generate.}

\item{.chain}{Either "alpha" or "beta" for alpha and beta chain respectively.}

\item{.segments}{List of segments (see "Details").}

\item{.P.list}{List of probabilities (see "Details").}
}
\value{
Mitcr data.frame with generated sequences.
}
\description{
Given the list of probabilities and list of segments (see "Details"), generate a artificial TCR repertoire.
}
\details{
For the generation of a artifical TCR repertoire user need to provide two objects: the list with segments and the list with probabilities.
List with segments is a list of 5 elements with 5 names: "TRAV", "TRAJ", "TRBV", "TRBD", "TRBJ". Each element is a data frame with following columns
(order is matters!): "V.allelles" with names for V-segments (for TRAV and TRBV; for others is "J.allelles" or "D.allelles"), "CDR3.position" (the function doesn't use it, but you
should provide it, fill it with zeros, for example), "Full.nucleotide.sequence" (the function doesn't use it), "Nucleotide.sequence" (function uses it for getting nucleotide
sequences of segments) and "Nucleotide.sequence.P" (the function doesn't use it).

List with probabilities is quite complicated, so just call \code{data(beta.prob)} for beta chain probabilities (alpha chain probabilities will be added soon).
}
\examples{
\dontrun{
# Load list of segments provided along with tcR.
data(segments)
# Load list of probabilities provided along with tcR.
data(beta.prob)
# Generate repertoire of beta chian with 10000 sequences.
artif.rep <- generate.tcR(10000, 'beta')
View(artif.rep)
}
}
\seealso{
\link{segments} \link{beta.prob}
}

