% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/kmers.R
\name{kmer.table}
\alias{get.kmer.column}
\alias{kmer.table}
\title{Make and manage the table of the most frequent k-mers.}
\usage{
kmer.table(.data, .heads = c(10, 100, 300, 1000, 3000, 10000, 30000), .nrow = 20,
           .clean = T, .meat = F)

get.kmer.column(.kmer.table.list, .head)
}
\arguments{
\item{.data}{Mitcr data.frame or a list with mitcr data.frames.}

\item{.heads}{Vector of parameter for the \code{head()} function, supplied sequentialy to the \code{get.kmers()} function. -1 means all rows.}

\item{.nrow}{How many most frequent k-mers include to the output table.}

\item{.clean}{Parameter for the \code{get.kmers()} function.}

\item{.meat}{Parameter for the \code{get.kmers()} function.}

\item{.kmer.table.list}{Result from the \code{kmer.table} function if \code{.data} supplied as a list.}

\item{.head}{Which columns with this head return.}
}
\value{
\code{kmer.table} - if \code{.data} is a data frame, than data frame with columns like "Kmers.X", "Count.X" where X - element from \code{.heads}.
If \code{.data} is a list, than list of such data frames.

\code{get.kmer.column} - data frame with first column with kmers and other columns named as a names of data frames, from which \code{.kmer.table.list}
was generated.
}
\description{
\code{kmer.table} - generate table with the most frequent k-mers.

\code{get.kmer.column} - get vector of k-mers from the k-mer table from the function \code{kmer.table}
}

