% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{mutated.neighbours}
\alias{mutated.neighbours}
\title{Get vertex neighbours.}
\usage{
mutated.neighbours(.G, .V, .order = 1)
}
\arguments{
\item{.G}{Mutation network.}

\item{.V}{Indices of vertices for which return neighbours.}

\item{.order}{Neighbours of which order return.}
}
\value{
List of length \code{.V} with data frames with vertex properties. First row in each data frame
is the vertex for which neighbours was returned.
}
\description{
Get all properties of neighbour vertices in a mutation network of specific vertices.
}
\examples{
\dontrun{
data(twb)
twb.shared <- shared.repertoire(twb)
G <- mutation.network(twb.shared)
head(mutated.neighbours(G, 1)[[1]])
#           label             vseg repind prob people npeople
# 1 CASSDRDTGELFF          TRBV6-4      1   -1   1111       4
# 2 CASSDSDTGELFF          TRBV6-4     69   -1   1100       2
# 3 CASSYRDTGELFF TRBV6-3, TRBV6-2    315   -1   1001       2
# 4 CASKDRDTGELFF TRBV6-3, TRBV6-2   2584   -1   0100       1
# 5 CASSDGDTGELFF          TRBV6-4   5653   -1   0010       1
# 6 CASSDRETGELFF          TRBV6-4   5950   -1   0100       1
}
}

