% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filters.R
\name{contamination.stats}
\alias{contamination.stats}
\alias{decontamination}
\title{Contamination filtering.}
\usage{
contamination.stats(.data1, .data2, .limit = 20, .col = 'Read.count')

decontamination(.data1, .data2, .limit = 20, .col = 'Read.count', .symm = T)
}
\arguments{
\item{.data1}{First data frame with columns 'CDR3.nucleotide.sequence' and 'Read.count'. Will be checked for contamination.}

\item{.data2}{Second data frame with such columns. Will be used for checking for sequences which contaminated the first one.}

\item{.limit}{Parameter for filtering: all sequences from \code{.data1} which are presented in \code{.data2} and (count of  in \code{.data2}) / (count of seq in \code{.data1}) >= \code{.limit} are removed.}

\item{.col}{Column's name with clonal count.}

\item{.symm}{if T then perform filtering out of sequences in .data1, and then from .data2. Else only from .data1.}
}
\value{
Filtered \code{.data1} or a list with filtered both \code{.data1} and \code{.data2}.
}
\description{
Occasionally DNA or RNA libraries are contaminate each other. To address this issue and estimate contamination rate \code{tcR} offers
\code{contamination.stats} and \code{decontamination} functions. The \code{decontamination} function received data
 (either data frame or a list with data frames) and a limit for clonal proportion as arguments.
 Script searches for a similar clones to the first data frame in the other (or performs pairwise searches if the given data is a list)
 and removes clones from the first data frame, which has been found in the second one with counts less or equal to 10 * counts of similar clones
 in the first one. Function \code{contamination.stats} will return the number of clones which will be removed with the \code{contamination.stats} function.
}

