% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{vis.heatmap}
\alias{vis.heatmap}
\title{Heatmap.}
\usage{
vis.heatmap(.data, .title = "Number of shared clonotypes",
  .labs = c("Sample", "Sample"), .legend = "Shared clonotypes",
  .na.value = NA, .text = T, .scientific = FALSE, .signif.digits = 4,
  .size.text = 4, .no.legend = F, .no.labs = F)
}
\arguments{
\item{.data}{Either a matrix with colnames and rownames specifyed or a data.frame with the first column of
strings for row names and other columns stands for values.}

\item{.title}{Main title of the plot.}

\item{.labs}{Labs names. Character vector of length 2 (for naming x-axis and y-axis).}

\item{.legend}{Title for the legend.}

\item{.na.value}{Replace NAs with this values.}

\item{.text}{if T then print \code{.data} values at tiles.}

\item{.scientific}{If T then force show scientific values in the heatmap plot.}

\item{.signif.digits}{Number of significant digits to show. Default - 4.}

\item{.size.text}{Size for the text in the cells of the heatmap, 4 by default.}

\item{.no.legend}{If T than remove the legend from the plot.}

\item{.no.labs}{If T than remove x / y labels names from the plot.}
}
\value{
ggplot object.
}
\description{
Plot a heatmap from a matrix or a data.frame
}
\examples{
\dontrun{
# Load your data.
load('immdata.rda')
# Perform cloneset overlap by amino acid sequences with V-segments.
imm.av <- repOverlap(immdata, .seq = 'aa', .vgene = T)
# Plot a heatmap.
vis.heatmap(imm.av, .title = 'Immdata - (ave)-intersection')
}
}
