% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.pkmod}
\alias{plot.pkmod}
\alias{plot.pdmod}
\alias{plot.tciinf}
\alias{plot.datasim}
\alias{plot.bayessim}
\title{Plot object with class 'pkmod'}
\usage{
\method{plot}{pkmod}(
  x,
  ...,
  inf,
  npts = 1000,
  title = NULL,
  xlab = "Time",
  ylab = "Concentration"
)

\method{plot}{pdmod}(
  x,
  ...,
  pkmod,
  inf,
  pars_pd,
  pars_pk = NULL,
  npts = 1000,
  plot_pk = TRUE,
  title = NULL,
  ecmpt = NULL,
  xlab = "Time",
  ylab_con = "Concentration",
  ylab_resp = "Response"
)

\method{plot}{tciinf}(
  x,
  ...,
  title = NULL,
  display = TRUE,
  xlab = "Time",
  ylab_con = "Concentration",
  ylab_resp = "Response"
)

\method{plot}{datasim}(
  x,
  ...,
  pars_prior = NULL,
  pars_post = NULL,
  pk_ix = NULL,
  pd_ix = NULL,
  xlab = "Time",
  ylab_con = "Concentration",
  ylab_resp = "Response"
)

\method{plot}{bayessim}(x, ..., xlab = "Time", ylab_con = "Concentration", ylab_resp = "Response")
}
\arguments{
\item{x}{Object returned from "bayes_control" function}

\item{...}{\dots}

\item{inf}{An infusion schedule object with columns "begin","end","infrt".}

\item{npts}{Number of points used to evaluate predicted concentrations.}

\item{title}{Title of plot.}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{pkmod}{PK model}

\item{pars_pd}{Parameters used by pdmod.}

\item{pars_pk}{Parameters used by pkmod.}

\item{plot_pk}{Logical. Should PK concentrations be plotted alongside
the PD response. Defaults to TRUE.}

\item{ecmpt}{Effect-site compartment number. Defaults to the last
compartment concentration returned by pkmod.}

\item{ylab_con}{y-axis label for concentration-time plot}

\item{ylab_resp}{y-axis label for response-time plot}

\item{display}{Logical. Should plots be printed or returned as an arrangeGrob object?}

\item{pars_prior}{Named vector of prior PK or PK-PD parameters}

\item{pars_post}{Named vector of posterior PK or PK-PD parameters}

\item{pk_ix}{Indicies of parameter vector(s) corresponding to PK parameters}

\item{pd_ix}{Indicies of parameter vector(s) corresponding to PD parameters}
}
\value{
ggplot object displaying predicted concentrations for a pkmod object.

ggplot object arranged with gridExtra::grid.arrange displaying
predicted response for a pdmod object.

gtable object using gridExtra::arrangeGrob

ggplot object displaying simulated data

ggplot object displaying simulated data.
}
\description{
Will show predicted concentrations in compartments associated with an infusion schedule.

User can provide a series of effect-site concentrations and a PD model or
 an infusion schedule with a PK-PD model.

Plot output returned by "bayes_control" function.
}
