% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_funcs.R, R/tcplQuery.R, R/tcplQueryAPI.R,
%   R/tcplSendQuery.R
\name{Query functions}
\alias{Query functions}
\alias{tcplQuery}
\alias{tcplQueryAPI}
\alias{tcplSendQuery}
\title{Wrappers for sending queries and fetching results}
\usage{
tcplQuery(
  query,
  db = getOption("TCPL_DB"),
  drvr = getOption("TCPL_DRVR"),
  tbl = NULL
)

tcplQueryAPI(resource = "data", fld = NULL, val = NULL, return_flds = NULL)

tcplSendQuery(
  query,
  db = getOption("TCPL_DB"),
  drvr = getOption("TCPL_DRVR"),
  tbl = NULL,
  delete = F
)
}
\arguments{
\item{query}{Character of length 1, the query string}

\item{db}{Character of length 1, the name of the tcpl database}

\item{drvr}{Character of length 1, which database driver to use}

\item{tbl}{Tables to be read queried}

\item{resource}{must be either data or assay to determine which api endpoint to hit}

\item{fld}{field that should be used to query the api}

\item{val}{value for specified field to query on}

\item{return_flds}{optional list of fields that should be returned}

\item{delete}{Logical of length 1, execute delete on queried table}
}
\description{
These functions send a query to the given database, and are the access point
for all tcpl functions that query or update the tcpl database.
}
\details{
Currently, the tcpl package supports the "MySQL", "example", and "API"
database drivers.

\code{tcplQuery} returns a data.table object with the query results.
\code{tcplSendQuery} sends a query, but does not fetch any results, and 
returns 'TRUE' or the error message given by the database. 
\code{tcplQueryAPI} returns a data.table object with the query results when
connected using "API" as driver.
}
\examples{
\dontrun{
# only with MySQL driver
tcplQuery("SELECT 'Hello World';")

# only with API driver
tcplConfDefault()
tcplQueryAPI(resource = "data", fld = "aeid", val = 2)
}

}
