% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitpow.R
\name{fitpow}
\alias{fitpow}
\title{Power Model Fit}
\usage{
fitpow(
  conc,
  resp,
  bidirectional = TRUE,
  verbose = FALSE,
  nofit = FALSE,
  nmin = 0.3
)
}
\arguments{
\item{conc}{Vector of concentration values NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{bidirectional}{If TRUE, model can be positive or negative; if FALSE, it
will be positive only.}

\item{verbose}{If TRUE, gives optimization and hessian inversion details.}

\item{nofit}{If nofit = TRUE, returns formatted output filled with missing values.}

\item{nmin}{Minimum allowed value of p.}
}
\value{
Named list containing: success, aic (Akaike Information Criteria),
  cov (success of covariance calculation), rme (root mean square error),
  modl (vector of model values at given concentrations),
  parameters values, parameter sd (standard deviation) estimates, pars
  (vector of parameter names), sds (vector of parameter sd names).
}
\description{
Function that fits to \eqn{f(x) = a*x^p} and returns generic model outputs.
}
\details{
Zero background and monotonically increasing absolute response are assumed.
Parameters are "a" (y scale), "p" (power), and error term "er".
success = 1 for a successful fit, 0 if optimization failed, and NA if
nofit = TRUE. cov = 1 for a successful hessian inversion, 0 if it fails, and NA
if nofit = TRUE. aic, rme, modl, parameters, and parameter sds are set to
NA in case of nofit or failure.
}
\examples{
fitpow(c(.03,.1,.3,1,3,10,30,100), c(0,.01,.1, .1, .2, .5, 2, 8))
}
