% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplfit2_core.R
\name{tcplfit2_core}
\alias{tcplfit2_core}
\title{Concentration-response curve fitting}
\usage{
tcplfit2_core(
  conc,
  resp,
  cutoff,
  force.fit = FALSE,
  bidirectional = TRUE,
  verbose = FALSE,
  do.plot = FALSE,
  fitmodels = c("cnst", "hill", "gnls", "poly1", "poly2", "pow", "exp2", "exp3", "exp4",
    "exp5"),
  poly2.biphasic = TRUE,
  errfun = "dt4",
  ...
)
}
\arguments{
\item{conc}{Vector of concentrations (NOT in log units).}

\item{resp}{Vector of responses.}

\item{cutoff}{Desired cutoff. If no absolute responses > cutoff and
force.fit = FALSE, will only fit constant model.}

\item{force.fit}{If force.fit = TRUE, will fit all models regardless of cutoff.}

\item{bidirectional}{If bidirectional = FALSE, will only give positive fits.}

\item{verbose}{If verbose = TRUE, will print optimization details and aics.}

\item{do.plot}{If do.plot = TRUE, will generate a plot comparing model curves.}

\item{fitmodels}{Vector of model names to try fitting. Missing models still
return a skeleton output filled with NAs.}

\item{poly2.biphasic}{If poly2.biphasic = TRUE, allows for biphasic polynomial 2
model fits (i.e. both monotonic and non-monotonic). (Defaults to TRUE.)}

\item{errfun}{Which error distribution to assume for each point, defaults to
"dt4". "dt4" is the original 4 degrees of freedom t-distribution. Another
supported distribution is "dnorm", the normal distribution.}

\item{...}{Other fitting parameters (deprecated).}
}
\value{
List of N(models) elements, one for each of the models run (up to 10),
followed by a element "modelnames", which is a vector of model names so
other functions can easily cycle through the output, and then the last element
"errfun", which indicates what distribution was used for error. For a full list, see the
documentation for the individual fitting method functions. For each model there
is a sublist with elements including:
  \itemize{
    \item success - was the model successfully fit
    \item aic - the AIC value
    \item cov - success of the the covariance matrix calculation
    \item rme - root mean error of the data around the curve
    \item modl - vector of model values at the given concentrations
    \item tp - the top of the curve fit
    \item ga - the AC50 or Hill paramters
    \item er - the error term
    \item ... other paramters specific to the model (see the documentation for the specific models)
    \item tp_sd, ga_sd, p_sd, etc., the values of the standard deviations of the paramters for the models
    \item er_sd - standard deviation of the error term
    \item pars - the names of the parameters
    \item sds - the names of the standard deviations of the paramters
  }
}
\description{
Concentration response curve fitting using the methods from BMDExpress
}
\details{
All models are equal to 0 at 0 concentration (zero background).
To add more models in the future, write a fit____ function, and add the model
name to the fitmodels and modelnames vectors.
}
\examples{
conc <- c(.03, .1, .3, 1, 3, 10, 30, 100)
resp <- c(0, .1, 0, .2, .6, .9, 1.1, 1)
output <- tcplfit2_core(conc, resp, .8,
  fitmodels = c("cnst", "hill"), verbose = TRUE,
  do.plot = TRUE
)
}
