% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOperations.R
\name{getOperations}
\alias{getOperations}
\title{Download all operations in account}
\usage{
getOperations(
  token = "",
  live = FALSE,
  from = Sys.Date() - 5,
  to = Sys.Date(),
  verbose = FALSE
)
}
\arguments{
\item{token}{token from Tinkoff account}

\item{live}{live trading - TRUE or sandbox (paper) trading - FALSE (default)}

\item{from}{from what date download history}

\item{to}{to what date download history}

\item{verbose}{display status of retrieval (default FALSE)}
}
\value{
returns an data.table object containing the information about all operations in account.
}
\description{
Makes a request to the server, and returns a list object with information about all operation related with your account if successful.
}
\details{
As described by the official Tinkoff Investments documentation
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
live = FALSE
token = 'your_sandbox_token_from_tcs_account'
getOperations(token,live)
}
\seealso{
\code{\link{getOrders}} \code{\link{getTrades}}
}
\author{
Vyacheslav Arbuzov
}
