% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_f.R
\name{get.class.id}
\alias{get.class.id}
\title{Gets Class 'Id' of a Frequency}
\usage{
get.class.id(frequency)
}
\arguments{
\item{frequency}{The frequency. It must be an \code{ldtf} object returned from \code{f.?} functions.}
}
\value{
A character that represents the class Id of this frequency.
}
\description{
Use this function to get the 'id' of a frequency class.
}
\details{
You need this ‘id’ to convert the character back to the object. Some frequencies have a constant class id. For example, the class id for ‘monthly’ data is m. Some class ‘ids’ have parameters in them. Note that the format is explained in f.? functions.
}
\examples{

freq <- f.x.times.a.day(f.daily(2023,5,16),13, 12)
freq_class_id <- get.class.id(freq) # this will be 'da13|d'.

}
