% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.quarterly}
\alias{f.quarterly}
\title{Create a Quarterly Frequency}
\usage{
f.quarterly(year, quarter)
}
\arguments{
\item{year}{An integer representing the year of the observation.}

\item{quarter}{An integer representing the quarter of the observation (It should be between 1 and 4).}
}
\value{
An object of class \code{ldtf} which is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{year}{Determines the \code{year}.}
\item{quarter}{Determines the \code{quarter}.}
}
\description{
Use this function to create a frequency for time-series data that occurs quarterly.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"#q#"} (first '#' is the \code{year}, second '#' is the
\code{quarter}; e.g., 2010q3 or 2010q4. Note that 2000q0 or 2000q5 are invalid.
\item \strong{Class Id} \code{"q"}
}
}
\examples{

q0 <- f.quarterly(2020, 2)
#     this is a quarterly frequency that refers to the second quarter of the year 2021.

q0_value_str <-  as.character(q0) # this will be '2020Q2'.
q0_class_str <- get.class.id(q0) # this will be 'q'.

q_new <- as.frequency("2021q3", "q")
#      this is a quarterly frequency that refers to the third quarter of the year 2021.

# Don't make the following mistakes:
\donttest{
q_invalid <- try(f.quarterly(2020, 0))
q_invalid <- try(f.quarterly(2020, 5))
q_invalid <- try(as.frequency("2021q0", "q"))
q_invalid <- try(as.frequency("2021q5", "q"))
q_invalid <- try(as.frequency("2021", "q"))
}

}
