% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipses.r
\name{ellipses}
\alias{ellipses}
\alias{sample_ellipse}
\alias{sample_cylinder_elliptical}
\title{Sample (with noise) from ellipses}
\usage{
sample_ellipse(n, ar = 1, sd = 0)

sample_cylinder_elliptical(n, ar = 1, width = 1, sd = 0)
}
\arguments{
\item{n}{Number of observations.}

\item{ar}{Aspect ratio for an ellipse (ratio of major and minor radii).}

\item{sd}{Standard deviation of (independent multivariate) Gaussian noise.}

\item{width}{Width of the cylinder (with respect to the fixed radius of the
ellipse).}
}
\description{
These functions generate uniform samples from configurations of
ellipses of major or minor radius 1 in 2- or 3-dimensional space,
optionally with noise.
}
\details{
The function \code{sample_ellipse()} uses the usual sinusoidal parameterization
from the unit interval to an ellipse with radii 1 and \code{1/ar}. The uniform
sample is generated through a rejection sampling process as described by
Diaconis, Holmes, and Shahshahani (2013).
}
\examples{
set.seed(97205L)

# ellipses in 2-space
x <- sample_ellipse(120, ar = 6)
plot(x, asp = 1, pch = 19, cex = .5)
x <- sample_ellipse(120, ar = 1/6)
plot(x, asp = 1, pch = 19, cex = .5)

# ellipses in 2-space
x <- sample_ellipse(120, ar = 6, sd = .1/6)
plot(x, asp = 1, pch = 19, cex = .5)
x <- sample_ellipse(120, ar = 1/6, sd = .1)
plot(x, asp = 1, pch = 19, cex = .5)

# cylinders in 3-space
x <- sample_cylinder_elliptical(120, ar = 1)
pairs(x, asp = 1, pch = 19, cex = .5)
x <- sample_cylinder_elliptical(120, ar = 3, width = 2*pi)
pairs(x, asp = 1, pch = 19, cex = .5)
}
