# output file of Digoxin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Digss.output<-function(B,F,K,E){
cat("\n")
cat("Report from tdm   << Digoxin >>\n")
cat("===============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Digoxin input data information--          \n")
     cat("    Gender = Male=1 ; Female=0                  \n")
     cat("    age = age(yr)                               \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    scr = serum creatinine conc.(mg/dL)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    c = measured steady-state conc.(ng/mL)      \n")
     cat("------------------------------------------------\n")               
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("  --Digoxin output data information--                     \n")
     cat("  cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("  Cmss_pr = predicted steady-state measured conc.(ng/mL)  \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(K)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (ng/mL) \n")
     cat("--------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}

# output file of Digoxin including individual information, predict PK parameters obtained from single concentration and dose adjustment (c<->d)
Digsscd.output<-function(B,F,K,E,G,H){
cat("\n")
cat("Report from tdm   << Digoxin >>\n")
cat("===============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("===============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Digoxin input data information--          \n")
     cat("    Gender = Male=1 ; Female=0                  \n")
     cat("    age = age(yr)                               \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    scr = serum creatinine conc.(mg/dL)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    c = measured steady-state conc.(ng/mL)      \n")
     cat("------------------------------------------------\n")      
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("  --Digoxin output data information--                     \n")
     cat("  cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("  Cmss_pr = predicted steady-state measured conc.(ng/mL)  \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(K)
cat("\n")
show(E)
cat("\n")
show(G)
cat("\n")
show(H)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (ng/mL) \n")
     cat("--------------------------------------------------------\n")
cat("===============================================================================\n")
cat(date(),"\n")
}

# output file of Carbamazepine including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Carss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Carbamazepine >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("    ts = sampling time(hr)                                 \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Carbamazepine output data information--              \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Carbamazepine including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Carsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Carbamazepine >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("    ts = sampling time(hr)                                 \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Carbamazepine output data information--              \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Aminoglycoside including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amiss.output<-function(B,F,G,H,D,E){
cat("\n")
cat("Report from tdm   << Aminoglycoside >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("----------------------------------------------------\n")
     cat("    --Aminoglycoside input data information--       \n")
     cat("    Gender = Male=1 ; Female=0                      \n")
     cat("    age = age(yr)                                   \n")
     cat("    bw = body weight(kg)                            \n")
     cat("    Ht = height(cm)                                 \n")
     cat("    Scr = serum creatinine conc.(mg/dL)             \n")
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    tin = infusion time(hr)                         \n")
     cat("    ts = sampling time since infusion end (hr)      \n")
     cat("    c = measured steady-state conc.(mg/L)           \n") 
     cat("----------------------------------------------------\n")     
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(H)
     cat("----------------------------------------------------------\n")
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    V = volume of distribution (L)      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  tin = desired infusion time (hr)                      \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Aminoglycoside including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amisscd.output<-function(B,F,G,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminoglycoside >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("----------------------------------------------------\n")
     cat("    --Aminoglycoside input data information--       \n")
     cat("    Gender = Male=1 ; Female=0                      \n")
     cat("    age = age(yr)                                   \n")
     cat("    bw = body weight(kg)                            \n")
     cat("    Ht = height(cm)                                 \n")
     cat("    Scr = serum creatinine conc.(mg/dL)             \n")
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    tin = infusion time(hr)                         \n")
     cat("    ts = sampling time since infusion end (hr)      \n")
     cat("    c = measured steady-state conc.(mg/L)           \n") 
     cat("----------------------------------------------------\n")     
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(J)
     cat("----------------------------------------------------------\n")
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    V = volume of distribution (L)      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  tin = desired infusion time (hr)                      \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Pediatric Digoxin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
PedDigss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Pediatric Digoxin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Pediatric Digoxin input data information--      \n")
     cat("    age = age (month)                                 \n") 
     cat("    bw = body weight(kg)                              \n")
     cat("    D = dose for each dosing interval(mcg)            \n")  
     cat("    tau = dosing interval(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)            \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("------------------------------------------------------------\n")
     cat("    --Pediatric Digoxin output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr/kg)                  \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")     
     cat("------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  Dose = desired/predicted dose (mcg)                   \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Pediatric Digoxin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
PedDigsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Pediatric Digoxin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Pediatric Digoxin input data information--      \n")
     cat("    age = age (month)                                 \n") 
     cat("    bw = body weight(kg)                              \n")
     cat("    D = dose for each dosing interval(mcg)            \n")  
     cat("    tau = dosing interval(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)            \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("------------------------------------------------------------\n")
     cat("    --Pediatric Digoxin output data information--           \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")     
     cat("------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  Dose = desired/predicted dose (mcg)                   \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Lithium carbonate including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Litss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Lithium carbonate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------------\n")
     cat("    --Lithium carbonate input data information--         \n")
     cat("    age = age (yr)                                       \n") 
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")    
     cat("---------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("    --Lithium carbonate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mEq/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Lithium carbonate including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Litsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Lithium carbonate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------------\n")
     cat("    --Lithium carbonate input data information--         \n")
     cat("    age = age (yr)                                       \n") 
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")    
     cat("---------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("    --Lithium carbonate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")    
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mEq/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Lithium citrate including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Litcitss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Lithium citrate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("----------------------------------------------------\n")
     cat("    --Lithium citrate input data information--      \n")
     cat("    age = age (yr)                                  \n") 
     cat("    f = age<50 (Y=0,N=1)                            \n") 
     cat("    bw = body weight(kg)                            \n")
     cat("    Scr = serum creatinine conc (mg/dL)             \n")   
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    c = measured steady-state conc.(mEq/L)          \n")    
     cat("----------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("    --Lithium citrate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mEq/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Lithium citrate including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Litcitsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Lithium citrate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("----------------------------------------------------\n")
     cat("    --Lithium citrate input data information--      \n")
     cat("    age = age (yr)                                  \n") 
     cat("    f = age<50 (Y=0,N=1)                            \n") 
     cat("    bw = body weight(kg)                            \n")
     cat("    Scr = serum creatinine conc (mg/dL)             \n")   
     cat("    D = dose for each dosing interval(mg)           \n")
     cat("    tau = dosing interval(hr)                       \n")
     cat("    c = measured steady-state conc.(mEq/L)          \n")    
     cat("----------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("    --Lithium citrate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")    
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mEq/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Phenytoin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Phess.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Phenytoin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------\n")
     cat("    --Phenytoin input data information--       \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")
     cat("-----------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
    cat("    --Phenytoin output data information--                \n")
     cat("    Vamx = maximum rate of metabolism (mg/day)           \n")
     cat("    Km = plasm concentration at which metabolidm is      \n")
     cat("         occuring at half the maximum rate (mg/L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("-------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("-------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Phenytoin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Phesscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Phenytoin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------\n")
     cat("    --Phenytoin input data information--       \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")
     cat("-----------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("    --Phenytoin output data information--                \n")
     cat("    Vamx = maximum rate of metabolism (mg/day)           \n")
     cat("    Km = plasm concentration at which metabolidm is      \n")
     cat("         occuring at half the maximum rate (mg/L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("-------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("-------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Children Valpraote including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
ChiValss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << children Valproate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Children Valpraote input data information--     \n")
     cat("    TBW = total body weight (Kg)                      \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)            \n")
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n") 
     cat("    c = measured steady-state conc.(mg/L)             \n")  
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Children Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("-------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("-------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Children Valpraote including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
ChiValsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << children Valproate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Children Valpraote input data information--     \n")
     cat("    TBW = total body weight (Kg)                      \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)            \n")
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n") 
     cat("    c = measured steady-state conc.(mg/L)             \n")  
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Children Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("-------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("-------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Valpraote including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Valss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Valproate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-------------------------------------------------------------\n")
     cat("   --Valpraote input data information--                      \n")
     cat("   age = age (yr)                                            \n")   
     cat("   INDI(indication)=1 for uncontrolled epilepsy, otherwise 0 \n")
     cat("   CBZ = combine CArbamazepine (Y=1, N=0)                    \n")
     cat("   ka = 4 for oral solution, 1 for enteric tablet            \n")
     cat("   D = dose for each dosing interval(mg)                     \n") 
     cat("   tau = dosing interval(hr)                                 \n")
     cat("   ts = sampling time (hr)                                   \n") 
     cat("   c = measured steady-state conc.(mg/L)                     \n")  
     cat("-------------------------------------------------------------\n")  
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("-------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("-------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Valpraote including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Valsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Valproate >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-------------------------------------------------------------\n")
     cat("   --Valpraote input data information--                      \n")
     cat("   age = age (yr)                                            \n")   
     cat("   INDI(indication)=1 for uncontrolled epilepsy, otherwise 0 \n")
     cat("   CBZ = combine CArbamazepine (Y=1, N=0)                    \n")
     cat("   ka = 4 for oral solution, 1 for enteric tablet            \n")
     cat("   D = dose for each dosing interval(mg)                     \n") 
     cat("   tau = dosing interval(hr)                                 \n")
     cat("   ts = sampling time (hr)                                   \n") 
     cat("   c = measured steady-state conc.(mg/L)                     \n")  
     cat("-------------------------------------------------------------\n")  
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Valpraote output data information--        \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("-------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("-------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Vancomycin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Vanss.output<-function(B,F,G,H,D,E){
cat("\n")
cat("Report from tdm   << Vancomycin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Vancomycin input data information--          \n")
     cat("    Gender = 1 for Male ; 0 for Female             \n")
     cat("    age = age(yr)                                  \n")
     cat("    bw = body weight (kg)                          \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)            \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    tin = infusion time(hr)                        \n") 
     cat("    ts = sampling time since infusion end (hr)     \n") 
     cat("    c = measured steady-state conc.(mg/L)          \n")
     cat("---------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(H)
     cat("----------------------------------------------------------\n")
     cat("    --Vancomycin output data information--            \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    V = volume of distribution (L)      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                      \n")
     cat("  D = desired/predicted dose (mg)                      \n")
     cat("  tau = desired dosing interval (hr)                   \n")
     cat("  tin = desired infusion time (hr)                     \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Vancomycin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Vansscd.output<-function(B,F,G,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Vancomycin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Vancomycin input data information--          \n")
     cat("    Gender = 1 for Male ; 0 for Female             \n")
     cat("    age = age(yr)                                  \n")
     cat("    bw = body weight (kg)                          \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)            \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    tin = infusion time(hr)                        \n") 
     cat("    ts = sampling time since infusion end (hr)     \n") 
     cat("    c = measured steady-state conc.(mg/L)          \n")
     cat("---------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(J)
     cat("----------------------------------------------------------\n")
     cat("    --Vancomycin output data information--            \n")
     cat("    cl = clerance (L/hr)                \n")
     cat("    V = volume of distribution (L)      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  tin = desired infusion time (hr)                      \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Enfuvirtide including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Enfss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Enfuvirtide >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Enfuvirtide input data information--      \n")
     cat("    Gender : 1 for Male ; 0 for Female          \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mg/L)       \n")
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Enfuvirtide output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)  \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Enfuvirtide including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Enfsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Enfuvirtide >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Enfuvirtide input data information--      \n")
     cat("    Gender : 1 for Male ; 0 for Female          \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mg/L)       \n")
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Enfuvirtide output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)  \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Indinavir including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Indss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Indinavir >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------\n")
     cat("    --Indinavir input data information--       \n")
     cat("    Gender = 1 for Male ; 0 for Female         \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    ts = sampling time(hr)                     \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")    
     cat("-----------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
      cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Indinavir including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Indsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Indinavir >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------\n")
     cat("    --Indinavir input data information--       \n")
     cat("    Gender = 1 for Male ; 0 for Female         \n")
     cat("    bw = body weight(kg)                       \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)      \n")
     cat("    tau = dosing interval(hr)                  \n")
     cat("    ts = sampling time(hr)                     \n")
     cat("    c = measured steady-state conc.(mg/L)      \n")    
     cat("-----------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
      cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Ritonavir including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Ritss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Ritonavir >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Ritonavir input data information--        \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-stat conc.(mg/L)        \n")    
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Ritonavir including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Ritsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Ritonavir >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Ritonavir input data information--        \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)           \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-stat conc.(mg/L)        \n")    
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Cyclosporine including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Cycss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Cyclosporine >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Cyclosporine input data information--        \n")
     cat("    bw = body weight(kg)                           \n")
     cat("    PTD = post-transplant day(day)                 \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)               \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    ts = sampling time(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)         \n")
     cat("---------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance (L/hr)                   \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Cyclosporine including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Cycsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Cyclosporine >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Cyclosporine input data information--        \n")
     cat("    bw = body weight(kg)                           \n")
     cat("    PTD = post-transplant day(day)                 \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)               \n")
     cat("    D = dose for each dosing interval(mg)          \n")
     cat("    tau = dosing interval(hr)                      \n")
     cat("    ts = sampling time(hr)                         \n")
     cat("    c = measured steady-state conc.(mcg/L)         \n")
     cat("---------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>   \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance (L/hr)                   \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Everolimus including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Evess.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Everolimus >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Everolimus input data information--       \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    age = age(yr)                               \n")
     cat("    race = 1 for black ; otherwise 0            \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mcg/L)      \n")  
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Everolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Everolimus including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Evesscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Everolimus >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Everolimus input data information--       \n")
     cat("    bw = body weight(kg)                        \n")
     cat("    age = age(yr)                               \n")
     cat("    race = 1 for black ; otherwise 0            \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(hr)                   \n")
     cat("    ts = sampling time(hr)                      \n")
     cat("    c = measured steady-state conc.(mcg/L)      \n")  
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("----------------------------------------------------------\n")
     cat("    --Everolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)    \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Tacrolimus including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Tacss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Tacrolimus >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Tacrolimus input data information--             \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1        \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1       \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                 \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)               \n")
     cat("    D = dose for each dosing interval(mg)             \n")
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time(hr)                            \n")  
     cat("    c = measured steady-state conc.(mcg/mL)           \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("-----------------------------------------------------------\n")
     cat("   --Tacrolimus output data information--                  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/mL) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/mL)   \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Tacrolimus including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Tacsscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Tacrolimus >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Tacrolimus input data information--             \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1        \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1       \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                 \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)               \n")
     cat("    D = dose for each dosing interval(mg)             \n")
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time(hr)                            \n")  
     cat("    c = measured steady-state conc.(mcg/mL)           \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
     cat("-----------------------------------------------------------\n")
     cat("   --Tacrolimus output data information--                  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/mL) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/mL)   \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mcg/L) \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Enoxaparin including individual information, predict PK parameters obtained from single concentration and dose adjustment  
Enoss.output<-function(B,F,G,D,E){
cat("\n")
cat("Report from tdm   << Enoxaparin >>\n")
cat("=========================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=========================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("   --Enoxaparin input data information--                   \n")
     cat("   Gender = 1 for Male ; 0 for Female                      \n") 
     cat("   TBW = body weight(kg)                                   \n")   
     cat("   Scr = serum creatinine conc.(mg/dL)                     \n")
     cat("   D = dose for each dosing interval(IU); 1mg = 100 IU     \n")
     cat("   tau = dosing interval(hr)                               \n")
     cat("   Amax = anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("---------------------------------------------------------------------------\n")
     cat("    --Enoxaparin output data information--                                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)                       \n")
     cat("    Amaxss_pr = predicted anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("---------------------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("---------------------------------------------------------------------------\n")
     cat("  --Explanation--                                                          \n")
     cat("  D = desired/predicted dose (IU,1mg=100IU)                                \n")
     cat("  tau = desired dosing interval (hr)                                       \n")
     cat("  Amax = desired/predicted anti-Xa maximal activity at stedy state (IU/mL) \n")
     cat("---------------------------------------------------------------------------\n")
cat("=========================================================================================\n")
cat(date(),"\n")
}

# output file of Enoxaparin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Enosscd.output<-function(B,F,G,D,E,H,I){
cat("\n")
cat("Report from tdm   << Enoxaparin >>\n")
cat("=========================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=========================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("   --Enoxaparin input data information--                   \n")
     cat("   Gender = 1 for Male ; 0 for Female                      \n") 
     cat("   TBW = body weight(kg)                                   \n")   
     cat("   Scr = serum creatinine conc.(mg/dL)                     \n")
     cat("   D = dose for each dosing interval(IU); 1mg = 100 IU     \n")
     cat("   tau = dosing interval(hr)                               \n")
     cat("   Amax = anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("---------------------------------------------------------------------------\n")
     cat("    --Enoxaparin output data information--                                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)                       \n")
     cat("    Amaxss_pr = predicted anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("---------------------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("---------------------------------------------------------------------------\n")
     cat("  --Explanation--                                                          \n")
     cat("  D = desired/predicted dose (IU,1mg=100IU)                                \n")
     cat("  tau = desired dosing interval (hr)                                       \n")
     cat("  Amax = desired/predicted anti-Xa maximal activity at stedy state (IU/mL) \n")
     cat("---------------------------------------------------------------------------\n")
cat("=========================================================================================\n")
cat(date(),"\n")
}

# output file of Imatinib mesylat including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Imass.output<-function(B,F,H,D,E){
cat("\n")
cat("Report from tdm   << Imatinib mesylate >>\n")
cat("====================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("====================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Imatinib mesylate input data information--      \n")
     cat("    BW = body weight(kg)                              \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                \n")
     cat("    Hb = Hemoglobin (g/dL)                            \n")
     cat("    WBC = white blood count (10^9/L)                  \n")
     cat("    n = dosing number                                 \n") 
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n")
     cat("    c = measured conc.(mg/L)                          \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(H)
     cat("----------------------------------------------------------\n")
     cat("    --Imatinib mesylate output data information--         \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)                \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc.(mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("====================================================================================\n")
cat(date(),"\n")
}


# output file of Imatinib mesylat including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Imasscd.output<-function(B,F,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Imatinib mesylate >>\n")
cat("====================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("====================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------\n")
     cat("    --Imatinib mesylate input data information--      \n")
     cat("    BW = body weight(kg)                              \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                \n")
     cat("    Hb = Hemoglobin (g/dL)                            \n")
     cat("    WBC = white blood count (10^9/L)                  \n")
     cat("    n = dosing number                                 \n") 
     cat("    D = dose for each dosing interval(mg)             \n") 
     cat("    tau = dosing interval(hr)                         \n")
     cat("    ts = sampling time (hr)                           \n")
     cat("    c = measured conc.(mg/L)                          \n")
     cat("------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>    \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(J)
     cat("----------------------------------------------------------\n")
     cat("    --Imatinib mesylate output data information--         \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)                \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>           \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc.(mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("====================================================================================\n")
cat(date(),"\n")
}


# output file of Warfarin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Warss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Warfarin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Warfarin input data information--         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(day)                  \n")
     cat("    INR = international normalized ratio        \n")
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("  --Warfarin output data information--                    \n")
     cat("  Cpmax = concentration related with maximum suppression  \n")
     cat("          of clotting factors (mg/L)                      \n")
     cat("  cl_F = clerance/bioavailability (L/day)                 \n")
     cat("  kc = first order rate constant for clotting factor      \n")
     cat("       degradation (1/day)                                \n")
     cat("  m = prothrombin complex activity remaining (%/day)      \n")
     cat("  v_F = volume of distribution/bioavailability (L)        \n")
     cat("  INR = predicted international normalized ratio          \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("----------------------------------------------------------\n")
     cat("  --Explanation--                                         \n")
     cat("  D = desired/predicted dose (mg)                         \n")
     cat("  tau = desired dosing interval (day)                     \n")
     cat("  INR = desired/predicted international normalized ratio  \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Warfarin including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Warsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Warfarin >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------\n")
     cat("    --Warfarin input data information--         \n")
     cat("    D = dose for each dosing interval(mg)       \n")
     cat("    tau = dosing interval(day)                  \n")
     cat("    INR = international normalized ratio        \n")
     cat("------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("----------------------------------------------------------\n")
     cat("  --Warfarin output data information--                    \n")
     cat("  Cpmax = concentration related with maximum suppression  \n")
     cat("          of clotting factors (mg/L)                      \n")
     cat("  cl_F = clerance/bioavailability (L/day)                 \n")
     cat("  kc = first order rate constant for clotting factor      \n")
     cat("       degradation (1/day)                                \n")
     cat("  m = prothrombin complex activity remaining (%/day)      \n")
     cat("  v_F = volume of distribution/bioavailability (L)        \n")
     cat("  INR = predicted international normalized ratio          \n")
     cat("----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("----------------------------------------------------------\n")
     cat("  --Explanation--                                         \n")
     cat("  D = desired/predicted dose (mg)                         \n")
     cat("  tau = desired dosing interval (day)                     \n")
     cat("  INR = desired/predicted international normalized ratio  \n")
     cat("----------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amianhirss.output<-function(B,F,G,H,D,E){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous IR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(H)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amianhirsscd.output<-function(B,F,G,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous IR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(J)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amianhcrss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous CR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous CR input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                              \n")
     cat("    age = age (yr)                                          \n")
     cat("    ht = height (cm)                                        \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                         \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                    \n") 
     cat("    D = dose for each dosing interval (mg)                  \n") 
     cat("    tau = dosing interval (hr)                              \n")
     cat("    C = measured steady-state conc.                         \n")
     cat("------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous CR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)             \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}

# output file of Aminophylline anhydrous CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amianhcrsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous CR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous CR input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                              \n")
     cat("    age = age (yr)                                          \n")
     cat("    ht = height (cm)                                        \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                         \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                    \n") 
     cat("    D = dose for each dosing interval (mg)                  \n") 
     cat("    tau = dosing interval (hr)                              \n")
     cat("    C = measured steady-state conc.                         \n")
     cat("------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous CR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)             \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous iv infusio including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amianhinfusionss.output<-function(B,F,K,D,E){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous iv infusion >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                                       \n")
     cat("    age = age (yr)                                                   \n")
     cat("    ht = height (cm)                                                 \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                                  \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                             \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("---------------------------------------------------------------------\n")               
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
cat("\n")
show(K)
     cat("---------------------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous iv infusion output data information--   \n")
     cat("   cl = clerance (L/hr)                            \n")
     cat("   V = volume of distribution (L)                  \n")
     cat("   Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  R = constant intravenous infusion rate (mg/hr)        \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline anhydrous iv infusio including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amianhinfusionsscd.output<-function(B,F,K,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminophylline anhydrous iv infusion >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline anhydrous iv infusion input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                                       \n")
     cat("    age = age (yr)                                                   \n")
     cat("    ht = height (cm)                                                 \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                                  \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                             \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("---------------------------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
cat("\n")
show(K)
     cat("---------------------------------------------------------------------\n")
     cat("   --Aminophylline anhydrous iv infusion output data information--   \n")
     cat("   cl = clerance (L/hr)                            \n")
     cat("   V = volume of distribution (L)                  \n")
     cat("   Cmss_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  R = constant intravenous infusion rate (mg/hr)        \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline dihydrous IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amidihirss.output<-function(B,F,G,H,D,E){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous IR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(H)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline dihydrous IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amidihirsscd.output<-function(B,F,G,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous IR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-----------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                             \n")
     cat("    age = age (yr)                                         \n")
     cat("    ht = height (cm)                                       \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                        \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                   \n") 
     cat("    D = dose for each dosing interval (mg)                 \n") 
     cat("    tau = dosing interval (hr)                             \n")
     cat("    ts = sampling time (hr)                                \n")   
     cat("    C = measured steady-state conc.                        \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(J)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}


# output file of Aminophylline dihydrous CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amidihcrss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous CR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>  \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous CR input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                              \n")
     cat("    age = age (yr)                                          \n")
     cat("    ht = height (cm)                                        \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                         \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                    \n") 
     cat("    D = dose for each dosing interval (mg)                  \n") 
     cat("    tau = dosing interval (hr)                              \n")
     cat("    C = measured steady-state conc.                         \n")
     cat("------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous CR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)             \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}

# output file of Aminophylline dihydrous CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amidihcrsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous CR >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous CR input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                              \n")
     cat("    age = age (yr)                                          \n")
     cat("    ht = height (cm)                                        \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                         \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                    \n") 
     cat("    D = dose for each dosing interval (mg)                  \n") 
     cat("    tau = dosing interval (hr)                              \n")
     cat("    C = measured steady-state conc.                         \n")
     cat("------------------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("-----------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous CR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)             \n")
     cat("-----------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}



# output file of Aminophylline dihydrous iv infusion including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Amidihinfusionss.output<-function(B,F,K,D,E){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous iv infusion >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                                       \n")
     cat("    age = age (yr)                                                   \n")
     cat("    ht = height (cm)                                                 \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                                  \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                             \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("---------------------------------------------------------------------\n")               
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
cat("\n")
show(K)
     cat("---------------------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous iv infusion output data information--   \n")
     cat("   cl = clerance (L/hr)                            \n")
     cat("   V = volume of distribution (L)                  \n")
     cat("   Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  R = constant intravenous infusion rate (mg/hr)        \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}

# output file of Aminophylline dihydrous iv infusion including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Amidihinfusionsscd.output<-function(B,F,K,D,E,H,I){
cat("\n")
cat("Report from tdm   << Aminophylline dihydrous iv infusion >>\n")
cat("=======================================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=======================================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------------------------\n")
     cat("    --Aminophylline dihydrous iv infusion input data information--   \n")
     cat("    Gender = Male=1 ; Female=0                                       \n")
     cat("    age = age (yr)                                                   \n")
     cat("    ht = height (cm)                                                 \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                                  \n")
     cat("    smoke = 1 for a amoker ; otherwise 0                             \n") 
     cat("    DL = loading dose (mg)                                 \n") 
     cat("    tinf = infusion time of loading dose (hr)              \n") 
     cat("    R = constant intravenous infusion rate (mg/hr)         \n") 
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    C = measured conc. (mg/L)                              \n")
     cat("---------------------------------------------------------------------\n")       
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
cat("\n")
show(K)
     cat("---------------------------------------------------------------------\n")
     cat("   --Aminophylline dihydrous iv infusion output data information--   \n")
     cat("   cl = clerance (L/hr)                            \n")
     cat("   V = volume of distribution (L)                  \n")
     cat("   Cm_pr = predicted measured conc.(mg/L)   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  R = constant intravenous infusion rate (mg/hr)        \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=======================================================================================\n")
cat(date(),"\n")
}

# output file of Oxtriphylline IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Oxtirss.output<-function(B,F,G,H,D,E){
cat("\n")
cat("Report from tdm   << Oxtriphylline IR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-------------------------------------------------\n")
     cat("    --Oxtriphylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(H)
     cat("---------------------------------------------------------\n")
     cat("   --Oxtriphylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=============================================================================\n")
cat(date(),"\n")
}

# output file of Oxtriphylline IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Oxtirsscd.output<-function(B,F,G,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Oxtriphylline IR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-------------------------------------------------\n")
     cat("    --Oxtriphylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(J)
     cat("---------------------------------------------------------\n")
     cat("   --Oxtriphylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Oxtriphylline CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Oxtcrss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Oxtriphylline CR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Oxtriphylline CR input data information--    \n")
     cat("    Gender = Male=1 ; Female=0                     \n")
     cat("    age = age (yr)                                 \n")
     cat("    ht = height (cm)                               \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                \n")
     cat("    smoke = 1 for a amoker ; otherwise 0           \n") 
     cat("    D = dose for each dosing interval (mg)         \n") 
     cat("    tau = dosing interval (hr)                     \n")
     cat("    C = measured steady-state conc.                \n")
     cat("---------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("   --Oxtriphylline CR output data information--       \n")
     cat("   cl_F = clerance/bioavailability (L/hr)             \n")
     cat("   V_F = volume of distribution/bioavailability (L)   \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)        \n")
     cat("------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=============================================================================\n")
cat(date(),"\n")
}

# output file of Oxtriphylline CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Oxtcrsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Oxtriphylline CR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Oxtriphylline CR input data information--    \n")
     cat("    Gender = Male=1 ; Female=0                     \n")
     cat("    age = age (yr)                                 \n")
     cat("    ht = height (cm)                               \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                \n")
     cat("    smoke = 1 for a amoker ; otherwise 0           \n") 
     cat("    D = dose for each dosing interval (mg)         \n") 
     cat("    tau = dosing interval (hr)                     \n")
     cat("    C = measured steady-state conc.                \n")
     cat("---------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("   --Oxtriphylline CR output data information--       \n")
     cat("   cl_F = clerance/bioavailability (L/hr)             \n")
     cat("   V_F = volume of distribution/bioavailability (L)   \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)        \n")
     cat("------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

# output file of Theophylline IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Theirss.output<-function(B,F,G,H,D,E){
cat("\n")
cat("Report from tdm   << Theophylline IR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-------------------------------------------------\n")
     cat("    --Theophylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(H)
     cat("---------------------------------------------------------\n")
     cat("   --Theophylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=============================================================================\n")
cat(date(),"\n")
}

# output file of Theophylline IR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Theirsscd.output<-function(B,F,G,J,D,E,H,I){
cat("\n")
cat("Report from tdm   << Theophylline IR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("-------------------------------------------------\n")
     cat("    --Theophylline IR input data information--  \n")
     cat("    Gender = Male=1 ; Female=0                   \n")
     cat("    age = age (yr)                               \n")
     cat("    ht = height (cm)                             \n") 
     cat("    CHF = 1 for yes ; otherwise = 0              \n")
     cat("    smoke = 1 for a amoker ; otherwise 0         \n") 
     cat("    D = dose for each dosing interval (mg)       \n") 
     cat("    tau = dosing interval (hr)                   \n")
     cat("    ts = sampling time (hr)                      \n")   
     cat("    C = measured steady-state conc.              \n")
     cat("-------------------------------------------------\n")
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
show(G)
show(J)
     cat("---------------------------------------------------------\n")
     cat("   --Theophylline IR output data information--  \n")
     cat("   cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("   V_F = volume of distribution/bioavailability (L)        \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mg/L)   \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)       \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)     \n")
     cat("---------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}


# output file of Theophylline CR including individual information, predict PK parameters obtained from single concentration and dose adjustment (C->D or D->C) 
Thecrss.output<-function(B,F,D,E){
cat("\n")
cat("Report from tdm   << Theophylline CR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Theophylline CR input data information--    \n")
     cat("    Gender = Male=1 ; Female=0                     \n")
     cat("    age = age (yr)                                 \n")
     cat("    ht = height (cm)                               \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                \n")
     cat("    smoke = 1 for a amoker ; otherwise 0           \n") 
     cat("    D = dose for each dosing interval (mg)         \n") 
     cat("    tau = dosing interval (hr)                     \n")
     cat("    C = measured steady-state conc.                \n")
     cat("---------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("   --Theophylline CR output data information--       \n")
     cat("   cl_F = clerance/bioavailability (L/hr)             \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)        \n")
     cat("------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("=============================================================================\n")
cat(date(),"\n")
}

# output file of Theophylline C including individual information, predict PK parameters obtained from single concentration and dose adjustment (C<->D) 
Thecrsscd.output<-function(B,F,D,E,H,I){
cat("\n")
cat("Report from tdm   << Theophylline CR >>\n")
cat("=============================================================================\n")
cat("version : 1.2.1, Copyright                                              \n")
cat("Created by : Mioa-ting Chen & Yung-jin Lee                              \n")
cat("=============================================================================\n\n")
cat("<< Patient's Data >>                                                    \n")
cat("\n")
show(B)      
     cat("---------------------------------------------------\n")
     cat("    --Theophylline CR input data information--    \n")
     cat("    Gender = Male=1 ; Female=0                     \n")
     cat("    age = age (yr)                                 \n")
     cat("    ht = height (cm)                               \n") 
     cat("    CHF = 1 for yes ; otherwise = 0                \n")
     cat("    smoke = 1 for a amoker ; otherwise 0           \n") 
     cat("    D = dose for each dosing interval (mg)         \n") 
     cat("    tau = dosing interval (hr)                     \n")
     cat("    C = measured steady-state conc.                \n")
     cat("---------------------------------------------------\n")        
cat("\n\n")                            
cat("<< PK parameters >>                                                      \n")
cat("\n")
show(samplesStats("*"))
cat("\n")
show(F)
     cat("------------------------------------------------------\n")
     cat("   --Theophylline CR output data information--       \n")
     cat("   cl_F = clerance/bioavailability (L/hr)             \n")
     cat("   Css_pr = predicted steady-state conc.(mg/L)        \n")
     cat("------------------------------------------------------\n")
cat("\n\n") 
cat("<< Dose adjustment >>                                                    \n")
cat("\n")
show(D)
cat("\n")
show(E)
cat("\n")
show(H)
cat("\n")
show(I)
     cat("--------------------------------------------------------\n")
     cat("  --Explanation--                                       \n")
     cat("  D = desired/predicted dose (mg)                       \n")
     cat("  tau = desired dosing interval (hr)                    \n")
     cat("  Css_trough = desired/predicted ss trough conc (mg/L)  \n")
     cat("--------------------------------------------------------\n")
cat("============================================================================\n")
cat(date(),"\n")
}

