% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_data-constructor.R, R/teal_data-extract.R
\name{teal_data}
\alias{teal_data}
\alias{[.teal_data}
\title{Comprehensive data integration function for \code{teal} applications}
\usage{
teal_data(..., join_keys = teal.data::join_keys(), code = character(0))

\method{[}{teal_data}(x, names)
}
\arguments{
\item{...}{any number of objects (presumably data objects) provided as \code{name = value} pairs.}

\item{join_keys}{(\code{join_keys} or single \code{join_key_set})
optional object with datasets column names used for joining.
If empty then no joins between pairs of objects.}

\item{code}{(\code{character}, \code{language}) optional code to reproduce the datasets provided in \code{...}.
Note this code is not executed and the \code{teal_data} may not be reproducible

Use \code{\link[=verify]{verify()}} to verify code reproducibility.}

\item{x}{(\code{teal_data})}

\item{names}{(\code{character}) names of objects included in \code{teal_subset} to subset}
}
\value{
A \code{teal_data} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Initializes a data for \code{teal} application.
}
\details{
A \code{teal_data} is meant to be used for reproducibility purposes. The class inherits from
\code{\link[teal.code:qenv]{teal.code::qenv}} and we encourage to get familiar with \CRANpkg{teal.code} first.
\code{teal_data} has following characteristics:
\itemize{
\item It inherits from the environment and methods such as \code{\link{$}}, \code{\link[=get]{get()}}, \code{\link[=ls]{ls()}}, \code{\link[=as.list]{as.list()}},
\code{\link[=parent.env]{parent.env()}} work out of the box.
\item \code{teal_data} is a locked environment, and data modification is only possible through the
\code{\link[teal.code:eval_code]{teal.code::eval_code()}} and \code{\link[teal.code:eval_code]{within.qenv()}} functions.
\item It stores metadata about the code used to create the data (see \code{\link[=get_code,teal_data-method]{get_code()}}).
\item It supports slicing (see \code{\link[teal.code:subset-qenv]{teal.code::subset-qenv}})
\item Is immutable which means that each code evaluation does not modify the original \code{teal_data}
environment directly.
\item It maintains information about relationships between datasets (see \code{\link[=join_keys]{join_keys()}}).
}
}
\section{Subsetting}{

\code{x[names]} subsets objects in \code{teal_data} environment and limit the code to the necessary needed to build limited
objects.
}

\examples{
teal_data(x1 = iris, x2 = mtcars)


# Subsetting
data <- teal_data()
data <- eval_code(data, "a <- 1;b<-2")
data["a"]
data[c("a", "b")]

join_keys(data) <- join_keys(join_key("a", "b", "x"))
join_keys(data["a"]) # should show empty keys
join_keys(data["b"])
join_keys(data)["a"] # should show empty keys
join_keys(data)["b"]

}
\seealso{
\code{\link[teal.code:eval_code]{teal.code::eval_code}}, \code{\link[=get_code,teal_data-method]{get_code()}}, \code{\link[=join_keys]{join_keys()}}, \code{\link[=names.teal_data]{names.teal_data()}}
}
