% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilteredDatasetDefault.R
\docType{class}
\name{DefaultFilteredDataset}
\alias{DefaultFilteredDataset}
\title{\code{DefaultFilteredDataset} \code{R6} class}
\description{
Stores any object as inert entity. Filtering is not supported.
}
\keyword{internal}
\section{Super class}{
\code{\link[teal.slice:FilteredDataset]{teal.slice::FilteredDataset}} -> \code{DefaultFilteredDataset}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DefaultFilteredDataset-new}{\code{DefaultFilteredDataset$new()}}
\item \href{#method-DefaultFilteredDataset-format}{\code{DefaultFilteredDataset$format()}}
\item \href{#method-DefaultFilteredDataset-get_call}{\code{DefaultFilteredDataset$get_call()}}
\item \href{#method-DefaultFilteredDataset-get_filter_state}{\code{DefaultFilteredDataset$get_filter_state()}}
\item \href{#method-DefaultFilteredDataset-set_filter_state}{\code{DefaultFilteredDataset$set_filter_state()}}
\item \href{#method-DefaultFilteredDataset-clear_filter_states}{\code{DefaultFilteredDataset$clear_filter_states()}}
\item \href{#method-DefaultFilteredDataset-get_filter_overview}{\code{DefaultFilteredDataset$get_filter_overview()}}
\item \href{#method-DefaultFilteredDataset-ui_active}{\code{DefaultFilteredDataset$ui_active()}}
\item \href{#method-DefaultFilteredDataset-ui_add}{\code{DefaultFilteredDataset$ui_add()}}
\item \href{#method-DefaultFilteredDataset-clone}{\code{DefaultFilteredDataset$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="get_dataname"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-get_dataname'><code>teal.slice::FilteredDataset$get_dataname()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="get_dataset"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-get_dataset'><code>teal.slice::FilteredDataset$get_dataset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="get_dataset_label"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-get_dataset_label'><code>teal.slice::FilteredDataset$get_dataset_label()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="get_filter_count"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-get_filter_count'><code>teal.slice::FilteredDataset$get_filter_count()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="get_keys"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-get_keys'><code>teal.slice::FilteredDataset$get_keys()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="print"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-print'><code>teal.slice::FilteredDataset$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="srv_active"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-srv_active'><code>teal.slice::FilteredDataset$srv_active()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.slice" data-topic="FilteredDataset" data-id="srv_add"><a href='../../teal.slice/html/FilteredDataset.html#method-FilteredDataset-srv_add'><code>teal.slice::FilteredDataset$srv_add()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-new"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-new}{}}}
\subsection{Method \code{new()}}{
Initializes this \code{DefaultFilteredDataset} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$new(dataset, dataname, label = character(0))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{any type of object; will not be filtered.}

\item{\code{dataname}}{(\code{character(1)})
syntactically valid name given to the dataset.}

\item{\code{label}}{(\code{character(1)})
label to describe the dataset.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Object of class \code{DefaultFilteredDataset}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-format"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-format}{}}}
\subsection{Method \code{format()}}{
Returns a formatted string representing this \code{DefaultFilteredDataset} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$format(show_all, trim_lines = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_all}}{(\code{logical(1)}) for method consistency, ignored.}

\item{\code{trim_lines}}{(\code{logical(1)}) flag specifying whether to trim lines if class names are too long.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The formatted string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-get_call"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-get_call}{}}}
\subsection{Method \code{get_call()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$get_call(sid)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sid}}{(\code{character(1)}) for method consistency, ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-get_filter_state"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-get_filter_state}{}}}
\subsection{Method \code{get_filter_state()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$get_filter_state()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-set_filter_state"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-set_filter_state}{}}}
\subsection{Method \code{set_filter_state()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$set_filter_state(state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state}}{(\code{teal_slices}) for method consistency, ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-clear_filter_states"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-clear_filter_states}{}}}
\subsection{Method \code{clear_filter_states()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$clear_filter_states(force)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{(\code{logical(1)}) for method consistency, ignored.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-get_filter_overview"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-get_filter_overview}{}}}
\subsection{Method \code{get_filter_overview()}}{
Creates row for filter overview in the form of \cr
\code{dataname} - unsupported data class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$get_filter_overview()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{data.frame}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-ui_active"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-ui_active}{}}}
\subsection{Method \code{ui_active()}}{
Overwrites parent method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$ui_active(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})
\code{shiny} module instance id.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Blank UI module that would list active filter states for this dataset.
}

\subsection{Returns}{
An empty \code{div}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-ui_add"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-ui_add}{}}}
\subsection{Method \code{ui_add()}}{
Overwrites parent method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$ui_add(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})
\code{shiny} module instance id.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Blank UI module that would list active filter states for this dataset.
}

\subsection{Returns}{
An empty \code{div}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DefaultFilteredDataset-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DefaultFilteredDataset-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DefaultFilteredDataset$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
