% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_args.R
\name{parse_ggplot2_args}
\alias{parse_ggplot2_args}
\title{Parse \code{ggplot2_args} object into the \code{ggplot2} expression}
\usage{
parse_ggplot2_args(
  ggplot2_args = teal.widgets::ggplot2_args(),
  ggtheme = c("default", "gray", "bw", "linedraw", "light", "dark", "minimal", "classic",
    "void", "test")
)
}
\arguments{
\item{ggplot2_args}{(\code{ggplot2_args})\cr
This argument could be a result of the \code{\link[=resolve_ggplot2_args]{resolve_ggplot2_args()}}.}

\item{ggtheme}{(\code{character(1)})\cr
name of the \code{ggplot2} theme to be applied, e.g. \code{"dark"}.}
}
\value{
(\code{list}) of up to three elements of class \code{languange}: \code{"labs"}, \code{"ggtheme"} and \code{"theme"}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
A function to parse expression from the \code{ggplot2_args} object.
}
\examples{
parse_ggplot2_args(
  resolve_ggplot2_args(ggplot2_args(
    labs = list(title = "TITLE"),
    theme = list(title = ggplot2::element_text(size = 20))
  ))
)

parse_ggplot2_args(
  resolve_ggplot2_args(
    ggplot2_args(
      labs = list(title = "TITLE"),
      theme = list(title = ggplot2::element_text(size = 20))
    )
  ),
  ggtheme = "gray"
)
}
