% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdata.R
\name{tdata2env}
\alias{tdata2env}
\title{Function to convert a \code{tdata} object to an \code{environment}}
\usage{
tdata2env(data)
}
\arguments{
\item{data}{(\code{tdata}) object}
}
\value{
An \code{environment}.
}
\description{
Any \code{reactive} expressions inside \code{tdata} are evaluated first.
}
\examples{

data <- new_tdata(
  data = list(iris = iris, mtcars = reactive(mtcars)),
  code = "iris <- iris
    mtcars = mtcars"
)

my_env <- isolate(tdata2env(data))

}
