% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_tests.R
\name{kuiper_test}
\alias{kuiper_test}
\title{Kuiper Test of Circular Uniformity}
\usage{
kuiper_test(x, alpha = 0, axial = TRUE, quiet = FALSE)
}
\arguments{
\item{x}{numeric vector containing the circular data which are expressed in degrees}

\item{alpha}{Significance level of the test. Valid levels are \code{0.01}, \code{0.05}, and \code{0.1}.
This argument may be omitted (\code{NULL}, the default), in which case, a range for the p-value will be returned.}

\item{axial}{logical. Whether the data are axial, i.e. \eqn{\pi}-periodical
(\code{TRUE}, the default) or circular, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{quiet}{logical. Prints the test's decision.}
}
\value{
list containing the test statistic \code{statistic} and the significance
level \code{p.value}.
}
\description{
Kuiper's test statistic is a rotation-invariant Kolmogorov-type test statistic.
The critical values of a modified Kuiper's test statistic are used according
to the tabulation given in Stephens (1970).
}
\details{
If \code{statistic > p.value}, the null hypothesis is rejected.
If not, randomness (uniform distribution) cannot be excluded.
}
\examples{
# Example data from Mardia and Jupp (2001), pp. 93
pidgeon_homing <- c(55, 60, 65, 95, 100, 110, 260, 275, 285, 295)
kuiper_test(pidgeon_homing, alpha = .05)

# San Andreas Fault Data:
data(san_andreas)
data("nuvel1")
PoR <- subset(nuvel1, nuvel1$plate.rot == "na")
sa.por <- PoR_shmax(san_andreas, PoR, "right")
kuiper_test(sa.por$azi.PoR, alpha = .05)
}
