% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca.predict.R
\name{cca.predict}
\alias{cca.predict}
\title{Make predictions using canonical correlation analysis (CCA)}
\usage{
cca.predict(X, Y, X.new, k.x, k.y)
}
\arguments{
\item{X}{An \code{(nvars x nobs)} data frame or matrix in which each column
contains all observations of measured (predictor) variables for a given 
timepoint or sample.  For example, if X represents a spatial variable that
was recorded at several timepoints, then each row of X should contain the
variable's measurement for all timepoints at a single location.}

\item{Y}{An \code{(nvars x nobs)} data frame or matrix in which each column
contains all observations of measured (response) variables for a given
timepoint or sample.}

\item{X.new}{An \code{(nvars x nobs.new)} data frame or matrix of values to
use to predict Y.new using CCA.}

\item{k.x}{An integer less than \code{(nobs)} indicating how many eigenvectors
of \code{(X)} to use in the CCA.}

\item{k.y}{An integer less than \code{(nobs)} indicating how many eigenvectors
of \code{(Y)} to use in the CCA.}
}
\value{
Y.new Predicted values for Y.new
}
\description{
Canonical correlation analysis (CCA) is sometimes referred to as a 
double-barreled principal component analysis.  Loosely, it fits a linear 
regression model to the scores of principal component decompositions for
of the predictors \code{X} and responses \code{Y}.  Oftentimes, only the 
largest \eqn{k} principal components are used to make predictions.
}
\details{
CCA has been used to predict a teleconnected response (like precipitation) 
using the remote field generating the teleconnection 
(like ocean temperatures).  In this application, principal components are 
often referred to as empirical orthogonal functions (EOFs).
}
\examples{

data("coprecip")
attach(coprecip)

# compute CCA predictions of Y (CO precipitation) given Z (Pacific ocean SSTs)
# using 2 principal components (aka. EOFs)
preds = cca.predict(X = Z, Y = Y, X.new = Z, k.x = 2, k.y = 2)

# compute R^2
1 - var(as.numeric(preds-Y)) / var(as.numeric(Y))

}
\references{
Cook, E.R., Briffa, K.R., and Jones, P.D., 1994, Spatial regression methods in dendroclimatology: A review and comparison of two techniques: International Journal of Climatology, v. 14, p. 379-402.

Glahn, H.R., 1968, Canonical Correlation and Its Relationship to Discriminant Analysis and Multiple Regression: Journal of the Atmospheric Sciences, v. 25, p. 23-31.
}
