% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.teleCor.R
\name{plot.teleCor}
\alias{plot.teleCor}
\title{Plots teleconnection correlation maps}
\usage{
\method{plot}{teleCor}(x, signif = F, coord.s = NULL, map = "world",
  region = ".", zlim = NULL, dots = NULL, ...)
}
\arguments{
\item{x}{object of class teleCor, containing pointwise correlations}

\item{signif}{if TRUE, then teleCor must have a column labeled 'signif' that
indicates which correlations are significant.  These correlations will be
printed in bold, and the rest will be printed more lightly}

\item{coord.s}{specifies the longitude and 
latitude of local coordinate for which to plot pointwise correlations 
(if type=='remote'). if 
NULL, the middle local coordinate will be plotted.}

\item{map}{name of map provided by the maps package. These include county, 
france, italy, nz, state, usa, world, world2.  By default, all stData plots
will include us state outlines.}

\item{region}{name of subregions to include. Defaults to . which includes 
all subregions. See documentation for map for more details.}

\item{zlim}{c(min, max) vector that specifies the colorscale limits}

\item{dots}{additional named arguments with defaults to pass to additional 
functions}

\item{...}{additional arguments to be passed to lower-level plotting functions}
}
\value{
a ggplot object with the specified map
}
\description{
This function provides basic plotting for analyses returned from cor.tel
}
\examples{

data("coprecip")

cors = teleCor(coprecip)
p = plot(cors, coords.s = c(-105, 39.73))

}
