% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmsh.R
\name{read_msh}
\alias{read_msh}
\title{Read Gmsh file}
\usage{
read_msh(fname)
}
\arguments{
\item{fname}{\code{character}, name of a Gmsh file.}
}
\value{
A \code{list} with the following elements:
\describe{
  \item{nelem}{Number of mesh elements (triangles)}
  \item{npoin}{Number of mesh points}
  \item{ikle}{A \code{nelem x 3} integer matrix of point indices (referring to \code{x} and \code{y}) defining the mesh elements}
  \item{ipobo}{An integer vector of length \code{npoin} defining the mesh boundaries (inner boundaries are zero, outer boundaries numbered)}
  \item{x}{A vector of length \code{npoin} giving the x coordinates of the mesh points}
  \item{y}{A vector of length \code{npoin} giving the y coordinates of the mesh points}
}
}
\description{
Reads the mesh file generated by Gmsh (only format version 2 supported).
}
\note{
So far only mesh file format version 2 is supported. Besides, only elements
'line' (considered as boundary) and 'triangle' (treated as actual mesh elements)
can be handled.
}
