% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{draw.hcross}
\alias{draw.hcross}
\title{Draw h-cross, range box, and box to enclose h-box}
\usage{
draw.hcross(rangebox = NULL, hcross = NULL,
rbox.col = "black", rbox.lty = "dotted", rbox.lwd = 4.5,
hbox.col = "lightgrey", hbox.lty = "solid", hbox.lwd = 4.5,
hcross.col = "black",hcross.lty = "solid",
hcross.signif.lwd = 7, hcross.nsd.lwd = 3.5)
}
\arguments{
\item{rangebox}{matrix where columns 1 and 2 are x and y dimensions and
rows 1 and 2 are the minimum and maximum values}

\item{hcross}{matrix where columns 1 and 2 are x and y dimensions and
rows 1 and 2 are the half-width of the confidence interval, which is often
95\% thus approximately 2x the standard error}

\item{rbox.col}{line color for the range box (default: \code{"black"})}

\item{rbox.lty}{line type for the range box (default: \code{"dotted"})}

\item{rbox.lwd}{line width for the range box (default: \code{4.5})}

\item{hbox.col}{line color for the box enclosing the h-cross
(default: \code{"lightgrey"})}

\item{hbox.lty}{line type for the box enclosing the h-cross
(default: \code{"dotted"})}

\item{hbox.lwd}{line width for the box enclosing the h-cross
(default: \code{4.5})}

\item{hcross.col}{line color for the h-cross (default: \code{"solid"})}

\item{hcross.lty}{line type for the h-cross (default: \code{"solid"})}

\item{hcross.signif.lwd}{line width for the h-cross where there is a
significant difference (default: \code{7})}

\item{hcross.nsd.lwd}{line width for the h-cross where there is a
significant difference (default: \code{3.5})}
}
\description{
Draw h-cross, range box, and box to enclose h-cross, described
by Castura, Rutledge, Ross & Næs (2022).
}
\details{
Draw h-cross, range box, and box to enclose h-box.
}
\references{
Castura, J.C., Rutledge, D.N., Ross, C.F., & Næs, T. (2022). Discriminability and uncertainty in principal component analysis (PCA) of temporal check-all-that-apply (TCATA) data. \emph{Food Quality and Preference}, 96, 104370. \doi{10.1016/j.foodqual.2021.104370}
}
