% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_template.R
\name{export_template}
\alias{export_template}
\title{Export template}
\usage{
export_template(
  x,
  out_fname = NULL,
  var_method = c("non-negative", "unbiased")
)
}
\arguments{
\item{x}{The result of \code{estimate_template}}

\item{out_fname}{Use \code{NULL} (default) to just return the template
objects directly. Otherwise, use a character vector of length 3 or 4 of file
path(s) to save the output to:
the mean template, the variance template, the variance decomposition, and
the FC template if present, in that order. If one file name is provided,
it will be appended with
\code{"_mean.[file_ext]"} for the template mean map,
\code{"_var.[file_ext]"} for the template variance map,
\code{"_varDecomp.rds"} for the variance decomposition, and
\code{"_FC.rds"} where \code{[file_ext]}
will be \code{"dscalar.nii"} for CIFTI input, \code{"nii"} for NIFTI input,
and \code{"rds"} for data input.}

\item{var_method}{\code{"non-negative"} (default) or \code{"unbiased"}}
}
\value{
If \code{is.null(out_fname)}, the templates in data matrix,
\code{"xifti"}, or \code{"nifti"} format, to match the format of the
original BOLD data. Otherwise, the paths to the new files specified by
\code{out_fname}.
}
\description{
Export the templates (mean and variance) as separate files for
visualization or processing outside of \code{templateICAr}.
}
\examples{
\dontrun{
 tm <- estimate_template(cii1_fnames, cii2_fnames, gICA_fname)
 export_template(tm, out_fname="my_template", var_method="unbiased")
}

}
