% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{run.algorithm}
\alias{run.algorithm}
\title{Apply a template algorithm file to an objective function}
\usage{
run.algorithm(
  algorithm_file,
  objective_function,
  input,
  output = NULL,
  options = NULL,
  work_dir = ".",
  trace = function(...) cat(paste0(..., "\\n")),
  silent = FALSE,
  save_data = TRUE
)
}
\arguments{
\item{algorithm_file}{templated algorithm file}

\item{objective_function}{function to apply algorithm on}

\item{input}{list of input arguments of function (eg. list(x1=list(min=0,max=1),x2=list(min=10,max=20)))}

\item{output}{list of output names}

\item{options}{algorithm options to overload default ones}

\item{work_dir}{working directory to run algorithm. will store output files, images, ..}

\item{trace}{display running info}

\item{silent}{quietness}

\item{save_data}{enable (by default) saving of data (in .Rds) along algorithm iterations.}
}
\value{
algorithm result (and algorithm object & files as attributes)
}
\description{
Apply a template algorithm file to an objective function
}
\examples{
run.algorithm(
  system.file("Brent.R", package="templr"),
  function(x) sin(x)-0.75,
  list(x=list(min=0,max=pi/2)),
  work_dir=tempdir()
  )
}
