% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempoCore.R
\name{tempo.permutationTest}
\alias{tempo.permutationTest}
\title{Permutation testing for TEMPO}
\usage{
tempo.permutationTest(mainResult, X, Y, genesets, ctrl, test,
  train = NULL, numPerms = 500, nCores = 24, pMseCutoff = 0.05)
}
\arguments{
\item{mainResult}{the data structure returned by tempo.runInstance when run using the true class assignments}

\item{X}{a matrix with sample ids as row names and gene ids as column names}

\item{Y}{a list indexed by sample ids, containing numerical values, e.g. ages}

\item{genesets}{a list of lists.  Outer list is indexed by gene set name, inner list contains all gene ids in a given gene set}

\item{ctrl}{a list of sample ids.  The list of control samples to use in scoring.}

\item{test}{a list of sample ids.  The list of test samples to use in scoring.}

\item{train}{a list of sample ids.  The list of control samples to train models on.  If null, train on ctrl.}

\item{numPerms}{number of permutations to do in permutation testing.  Defaults to 500}

\item{nCores}{number of thread to spawn for permutation testing.  This should likely be set to some number less than or equal to
the number of cores on your machine.  If nCores is less than 0, nCores will be set to the return value of \code{\link[parallel]{detectCores}}.}

\item{pMseCutoff}{gene sets with a p-value associated with the control mean squared error below this cuttof are not evaluated further.}
}
\value{
mainResult, with the score data frame annotated with p-values for ctrlMSE ("pMSE") and score ("p") and fdr for the score p-value ("BH") for each gene set.
Note that "BH" will be 2 for any gene set where pMSE > pMseCutoff
}
\description{
Does permutation testing for the results of an instance of tempo run on the true class assignments.  Called by \code{\link{tempo.run}}.
}
\examples{
data("dflatExample")
data("gse32472Example")
data("gse32472ExampleTempoResults")

\donttest{
# Cross-validation can be run seperately once the initial model-building and scoring is complete.
# Note that running this example may take several minutes.
results = tempo.runInstance(ctrl=gse32472Example$ctrl,
    test=gse32472Example$test,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age)
results = tempo.permutationTest(mainResult=results,
    ctrl=gse32472Example$ctrl,
    test=gse32472Example$test,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age,
    nCores=-1)
}

# Reporting thresholds, number of permutations, and number of CPU cores used can all be changed.
# This command is suitable for demonstration purposes, but significance values will not be
# meaningful.
results2 = tempo.permutationTest(mainResult=gse32472ExampleTempoResults,
    ctrl=gse32472Example$ctrl,
    test=gse32472Example$test,
    genesets=dflatExample,
    X=gse32472Example$data,
    Y=gse32472Example$age,
    numPerms=2,nCores=2,pMseCutoff = 1)
}
