% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEMPTED.R
\name{format_tempted}
\alias{format_tempted}
\title{Format data table into the input of tempted}
\usage{
format_tempted(
  featuretable,
  timepoint,
  subjectID,
  threshold = 0.95,
  pseudo = NULL,
  transform = "clr"
)
}
\arguments{
\item{featuretable}{A sample by feature matrix.}

\item{timepoint}{The time stamp of each sample, matched with the rows of \code{featuretable}.}

\item{subjectID}{The subject ID of each sample, matched with the rows of \code{featuretable}.}

\item{threshold}{A threshold for feature filtering for microbiome data.
Features with zero value percentage > threshold will be excluded. Default is 0.95.}

\item{pseudo}{A small number to add to all the counts before
normalizing into proportions and log transformation.
Default is 1/2 of the smallest non-zero value that is specific for each sample.
This pseudo count is added for \code{transform=c("logcomp", "clr", "logit")}.}

\item{transform}{The transformation applied to the data.
\code{"logcomp"} for log of compositions.
\code{"comp"} for compositions.
\code{"ast"} for arcsine squared transformation.
\code{"clr"} for central log ratio transformation.
\code{"lfb"} for log 2 fold change over baseline (first time point) transformation.
\code{"logit"} for logit transformation.
\code{"none"} for no transformation.
Default \code{transform="clr"} is recommended for microbiome data.
For data that are already transformed, use \code{transform="none"}.}
}
\value{
A length n list of matrices as the input of \code{\link{tempted}} and \code{\link{svd_centralize}}.  Each matrix represents a subject, with columns representing samples from this subject, the first row representing the sampling time points, and the following rows representing the feature values.
}
\description{
This function applies a variety of transformations to the read counts and
format the sample by feature table and meta data into a data list
that can be used as the input of \code{\link{tempted}} and \code{\link{svd_centralize}}.
For data that are not read counts, or data that are not microbiome data,
the user can apply their desired transformation to the data before formatting into list.
}
\seealso{
Examples can be found in \code{\link{tempted}}.
}
