% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss_gen.R
\name{miss_gen}
\alias{miss_gen}
\title{Assignment of missingness to tensor time series}
\usage{
miss_gen(dt, type = "random", p = 0.7)
}
\arguments{
\item{dt}{Tensor time series, written in an array with dimension K+1 and mode-1 as the time mode.}

\item{type}{Type of missingness, where "random" is random missing with probability p, "simul" is missingness on the last half along all dimensions, "mix" is a mixture of "random" and "simul". Default is "random".}

\item{p}{If type is "random", then each entry is randomly missing with probability 1-p. Default is 0.7.}
}
\value{
A multi-dimensional array with dimension K+1, where mode-1 is the time mode and missing entries are denoted by NA
}
\description{
Assign missingness to a given order-K tensor time series, where the maximum K is 4
}
\examples{
K = 3;
TT = 10;
d = c(20,20,20);
r = c(2,2,2);
re = c(2,2,2);
eta = list(c(0,0), c(0,0), c(0,0));
coef_f = c(0.7, 0.3, -0.4, 0.2, -0.1);
coef_fe = c(-0.7, -0.3, -0.4, 0.2, 0.1);
coef_e = c(0.8, 0.4, -0.4, 0.2, -0.1);
tensor_gen(K,TT,d,r,re,eta, coef_f, coef_fe, coef_e);
data_test = tensor_gen(K,TT,d,r,re,eta, coef_f, coef_fe, coef_e);
miss_gen(data_test$X);


}
