% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_decompositions.R
\name{hosvd}
\alias{hosvd}
\title{Calculate the (truncated) higher-order SVD (HOSVD).}
\usage{
hosvd(Y, r = NULL)
}
\arguments{
\item{Y}{An array of numerics.}

\item{r}{A vector of integers. The rank of the truncated HOSVD.}
}
\value{
\code{U} A list of matrices with orthonormal columns. Each matrix
  contains the mode-specific singular vectors of its mode.

  \code{S} An all-orthogonal array. This is the core array from the HOSVD.
}
\description{
Calculates the left singular vectors of each matrix unfolding of an array,
then calculates the core array. The resulting output is a Tucker
decomposition.
}
\details{
If \code{r} is equal to the rank of \code{Y}, then \code{Y} is equal to
\code{atrans(S, U)}, up to numerical accuracy.

More details on the HOSVD can be found in
\href{http://epubs.siam.org/doi/abs/10.1137/S0895479896305696}{ De Lathauwer
et. al. (2000)}.
}
\examples{
#Generate random data.
p <- c(2, 3, 4)
X <- array(stats::rnorm(prod(p)), dim = p)

#Calculate HOSVD.
hosvd_x <- hosvd(X)
S <- hosvd_x$S
U <- hosvd_x$U

#Recover X.
trim(X - atrans(S, U))

#S is all-orthogonal.
trim(mat(S, 1) \%*\% t(mat(S, 1)))
trim(mat(S, 2) \%*\% t(mat(S, 2)))
trim(mat(S, 3) \%*\% t(mat(S, 3)))
}
\author{
Peter Hoff.
}
\references{
De Lathauwer, L., De Moor, B., & Vandewalle, J. (2000).
  \href{http://epubs.siam.org/doi/abs/10.1137/S0895479896305696}{A
  multilinear singular value decomposition}. \emph{SIAM journal on Matrix
  Analysis and Applications}, 21(4), 1253-1278.
}
\keyword{decompositions}

