% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like_inference.R
\name{lrt_stat}
\alias{lrt_stat}
\title{Calculate the likelihood ratio test statistic.}
\usage{
lrt_stat(sig_null, sig_alt, p)
}
\arguments{
\item{sig_null}{A numeric. The MLE of the total variation parameter under the
null (the standard deviation version).}

\item{sig_alt}{A numeric. The MLE of the total variation parameter under the
alternative (the standard deviation version).}

\item{p}{A vector of integers. The dimension of the array.}
}
\value{
A numeric. The likelihood ratio test statistic.
}
\description{
Calulate the likelihood ratio test statistic for Kronecker structured
covariance models.
}
\details{
The LRT statistic is the exact same for all elliptically distributed
Kronecker structured covariance models (not just the normal). The
distribution of the likelihood ratio test statistic does change.
}
\author{
David Gerard.
}
\references{
Gerard, D. C., & Hoff, P. D. (2014).
  \href{http://arxiv.org/abs/1410.1094}{A higher-order LQ decomposition for
  separable covariance models}. \emph{arXiv preprint arXiv:1410.1094.}
}
\seealso{
\code{\link{holq}} for obtaining the MLE of the total variation
  parameter.

  \code{\link{lrt_null_dist_dim_same}} for getting the null distribution of
  the likelihood ratio test statistic.
}
\keyword{likelihood}

