% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equi_mcmc.R
\name{rmirror_wishart}
\alias{rmirror_wishart}
\title{Sample from the mirror-Wishart distribution.}
\usage{
rmirror_wishart(nu, Phi)
}
\arguments{
\item{nu}{An integer. The degrees of freedom in the mirror-Wishart.}

\item{Phi}{A matrix. The scale matrix of the mirror-Wishart.}
}
\value{
A matrix drawn from the mirror-Wishart distribution with \code{nu}
  degrees of freedom and scale matrix \code{Phi}.
}
\description{
Given scale matrix \code{Phi} and degrees of freedom \code{nu},
\code{rmirror_wishart} will sample from the mirror-Wishart distribution.
}
\details{
\eqn{S} is mirror-Wishart(\eqn{\nu,\Phi}) if \deqn{S = UV'VU',} where
\eqn{VV'} is the lower triangular Cholesky decomposition of a
Wishart(\eqn{\nu,I})-distributed random matrix and \eqn{UU'} is the upper
triangular Cholesky decomposition of \eqn{\Phi}. That is, \eqn{V} is lower
triangular and \eqn{U} is upper triangular. For details on its applications,
see
\href{https://doi.org/10.1016/j.jmva.2015.01.020}{Gerard and Hoff (2015)}.
}
\references{
Gerard, D., & Hoff, P. (2015). Equivariant minimax
    dominators of the MLE in the array normal model.
    \emph{Journal of Multivariate Analysis}, 137, 32-49.
    \url{https://doi.org/10.1016/j.jmva.2015.01.020}
    \url{http://arxiv.org/pdf/1408.0424.pdf}
}
\seealso{
\code{\link{sample_right_wishart}}
}
\author{
David Gerard.
}
\keyword{equivariance}
\keyword{simulation}
