% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stergm.R
\name{stergm}
\alias{stergm}
\title{Separable Temporal Exponential Family Random Graph Models (Deprecated)}
\usage{
stergm(
  nw,
  formation,
  dissolution,
  constraints = ~.,
  estimate,
  times = NULL,
  offset.coef.form = NULL,
  offset.coef.diss = NULL,
  targets = NULL,
  target.stats = NULL,
  eval.loglik = NVL(getOption("tergm.eval.loglik"), getOption("ergm.eval.loglik")),
  control = control.stergm(),
  verbose = FALSE,
  ...,
  SAN.offsets = NULL
)
}
\arguments{
\item{nw}{A \code{\link[network]{network}} object (for EGMME); or
\code{\link[networkDynamic]{networkDynamic}} object, a
\code{\link{network.list}} object, or a \code{\link{list}} containing
networks (for CMLE and CMPLE).

\code{stergm} understands the \code{\link{lasttoggle}} "API".}

\item{formation, dissolution}{One-sided \code{\link{ergm}}-style formulas for
the formation and dissolution models, respectively.  In \code{stergm},
the dissolution formula is parameterized in
terms of tie persistence: negative coefficients imply lower rates of persistence
and postive coefficients imply higher rates.  The dissolution effects are simply the
negation of these coefficients.}

\item{constraints}{A formula specifying one or more constraints
on the support of the distribution of the networks being modeled. Multiple constraints
may be given, separated by \dQuote{+} and \dQuote{-} operators. See
\code{\link{ergmConstraint}} for the detailed explanation of
their semantics and also for an indexed list of the constraints visible to the \CRANpkg{ergm} package.

The default is to have no constraints except those provided through
the \code{\link{ergmlhs}} API.

Together with the model terms in the formula and the reference measure, the constraints
define the distribution of networks being modeled.

It is also possible to specify a proposal function directly either
by passing a string with the function's name (in which case,
arguments to the proposal should be specified through the
\code{MCMC.prop.args} argument to the relevant control function, or
by giving it on the LHS of the hints formula to \code{MCMC.prop}
argument to the control function. This will override
the one chosen automatically.

Note that not all possible combinations of constraints and reference
measures are supported. However, for relatively simple constraints
(i.e., those that simply permit or forbid specific dyads or sets of
dyads from changing), arbitrary combinations should be possible.}

\item{estimate}{One of "EGMME" for Equilibrium Generalized Method of Moments
Estimation, based on a single network with some temporal information and
making an assumption that it is a product of a STERGM process running to its
stationary (equilibrium) distribution; "CMLE" for Conditional Maximum
Likelihood Estimation, modeling a transition between two networks, or
"CMPLE" for Conditional Maximum PseudoLikelihood Estimation, using MPLE
instead of MLE.  CMPLE is extremely inaccurate at this time.}

\item{times}{For CMLE and CMPLE estimation, times or indexes at
which the networks whose transition is to be modeled are
observed. Default to \code{c(0,1)} if \code{nw} is a
\code{\link[networkDynamic]{networkDynamic}} and to
\code{1:length(nw)} (all transitions) if \code{nw} is a
\code{\link{network.list}} or a \code{\link{list}}. Unused for
EGMME. Note that at this time, the selected time points will be
treated as temporally adjacent. Irregularly spaced time series
are not supported at this time.}

\item{offset.coef.form}{Numeric vector to specify offset formation
parameters.}

\item{offset.coef.diss}{Numeric vector to specify offset dissolution
parameters.}

\item{targets}{One-sided \code{\link{ergm}}-style formula specifying
statistics whose moments are used for the EGMME. Unused for CMLE and CMPLE.
Targets is required for EGMME estimation. It may contain any valid ergm
terms.  Any offset terms are used only during the
preliminary SAN run; they are removed automatically for the EGMME proper.
If \code{targets} is specified as a character
(one of \code{"formation"} and \code{"dissolution"}) then
the function \code{\link{.extract.fd.formulae}} is used to determine the
corresponding formula; the user should be aware of its behavior and limitations.}

\item{target.stats}{A vector specifying the values of the \code{targets}
statistics that EGMME will try to match.  Defaults to the statistics of
\code{nw}. Unused for CMLE and CMPLE.}

\item{eval.loglik}{Whether or not to calculate the log-likelihood
of a CMLE STERGM fit. See \code{\link{ergm}} for details. Can be
set globally via \code{option(tergm.eval.loglik=...)}, falling back to
\code{getOption("ergm.eval.loglik")} if not set.}

\item{control}{A list of control parameters for algorithm tuning.
Constructed using \code{\link{control.stergm}}.  Remapped to
\code{\link{control.tergm}}.}

\item{verbose}{A logical or an integer to control the amount of
progress and diagnostic information to be printed. \code{FALSE}/\code{0}
produces minimal output, with higher values producing more
detail. Note that very high values (5+) may significantly slow
down processing.}

\item{\dots}{Additional arguments, to be passed to lower-level functions.}

\item{SAN.offsets}{Offset coefficients (if any) to use during the SAN run.}
}
\value{
\code{\link{stergm}} returns an object of class \code{\link{tergm}};
see \code{\link[=tergm]{tergm()}} for details and methods.
}
\description{
\code{\link{stergm}} is used for finding Separable Temporal ERGMs'
(STERGMs) Conditional MLE (CMLE) (Krivitsky and Handcock, 2014) and
Equilibrium Generalized Method of Moments Estimator (EGMME)
(Krivitsky, 2009). This function is deprecated in favor of
\code{\link[=tergm]{tergm()}}, whose special case it is, and may be removed in a future
version.
}
\details{
The \code{stergm} function uses a pair of formulas, \code{formation} and
\code{dissolution} to model tie-dynamics.  The dissolution formula, however, is
parameterized in terms of tie persistence: negative coefficients imply lower
rates of persistence and postive coefficients imply higher rates.
The dissolution effects are simply the negation of these coefficients, but
the discrepancy between the terminology and interpretation has always been
unfortunate, and we have fixed this in the new \code{tergm} function.

If you are making the transition from old \code{stergm} to new \code{tergm}, note that
the \code{dissolution} formula in \code{stergm} maps to the new \code{Persist()}
operator in the \code{tergm} function, NOT the \code{Diss()} operator.

\strong{Model Terms} See \code{\link{ergm}} and \code{\link{ergm-terms}} for
details. At this time, only linear ERGM terms are allowed.  \itemize{
\item For a brief demonstration, please see the tergm package vignette:
\code{browseVignettes(package='tergm')} \item A more detailed tutorial is
available on the statnet wiki:
\url{https://statnet.org/Workshops/tergm/tergm_tutorial.html} }
}
\references{
Krivitsky P.N. and Handcock M.S. (2014) A Separable Model for Dynamic Networks. \emph{Journal of the Royal Statistical Society, Series B}, 76(1): 29-46. \doi{10.1111/rssb.12014}

Krivitsky, P.N. (2012). Modeling of Dynamic Networks based on
Egocentric Data with Durational Information. \emph{Pennsylvania State
University Department of Statistics Technical Report}, 2012(2012-01).
\url{https://web.archive.org/web/20170830053722/https://stat.psu.edu/research/technical-report-files/2012-technical-reports/TR1201A.pdf}
}
\seealso{
ergm, network, \\%v\\%, \\%n\\%, \code{\link{ergm-terms}}
}
