% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_ergm}
\alias{simulate_ergm}
\title{A Version of ergm::simulate.ergm Tailored to tergmLite Simulation}
\usage{
simulate_ergm(state, coef, control)
}
\arguments{
\item{state}{An \code{ergm_state} object representing the starting state
for the simulation.}

\item{coef}{Vector of coefficients for the generative model.}

\item{control}{A control list of class \code{control.simulate.formula}.}
}
\value{
Returns a named list with members \code{el} (the updated network edgelist
representation) and \code{state} (the \code{ergm_state} object returned by
\code{ergm_MCMC_slave}).
}
\description{
Resimulates an edgelist given ergm_state data representation
             and model coefficients.
}
\details{
This function is used within the network resimulation module in \code{EpiModel}
to update cross-sectional ERGMs based on the model coefficients and current
network structure. If network structure (e.g., number of nodes) or nodal attributes
has changed since the last simulation, this network resimulation should be run
only after \code{\link{updateModelTermInputs}}.
}
\examples{
\dontrun{
library("EpiModel")

# Set seed for reproducibility
set.seed(1234)

nw <- network_initialize(100)
nw <- set_vertex_attribute(nw, "group", rep(1:2, each = 50))
formation <- ~edges + nodefactor("group")
target.stats <- c(15, 10)
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 1)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3, inf.prob.g2 = 0.1)
init <- init.net(i.num = 10, i.num.g2 = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5, tergmLite = TRUE)

# Full network structure after initialization
dat <- crosscheck.net(x, param, init, control)
dat <- initialize.net(x, param, init, control)
str(dat, max.level = 1)

# Current network structure
dat$el[[1]]

# New network structure (all edges are new)
dat$el[[1]] <- simulate_ergm(state = dat$p[[1]]$state,
                             coef = dat$nwparam[[1]]$coef.form,
                             control = dat$control$mcmc.control[[1]])$el
dat$el[[1]]
}

}
