% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdims.R
\name{pdims}
\alias{pdims}
\title{Parameter Dimensions}
\usage{
pdims(x, ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}
}
\value{
A named list of the dimensions of each parameter.
}
\description{
Gets the parameter dimensions of an object as a named list of the dimensions
of each parameter.
}
\details{
Errors if the parameter dimensions are inconsistent.

A named list of the dimensions of each parameter can be converted
into the equivalent \code{\link[=term-vector]{term-vector()}} using \code{\link[=term]{term()}}.
}
\examples{
pdims(as.term(c("alpha[1]", "alpha[3]", "beta[1,1]", "beta[2,1]")))
}
\seealso{
\code{\link[=dims]{dims()}} and \code{\link[=term]{term()}}
}
