% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_plot.R
\name{h_get_timepoint_vars}
\alias{h_get_timepoint_vars}
\title{Time points helper for Covariance Plot}
\usage{
h_get_timepoint_vars(vcov_matrix, time_prefix = NULL)
}
\arguments{
\item{vcov_matrix}{(\code{matrix})\cr symmetric covariance matrix with identical
row and column names.}

\item{time_prefix}{(\code{string})\cr string in the names of \code{vcov_matrix} that
precedes the time point value.}
}
\value{
This function returns a list with of two sets of numbers:
\code{row_time} and \code{col_time}, identifying the timepoints of the upper triangular
part of \code{vcov_matrix}.
}
\description{
Get the inputted symmetric matrices row and column labels as numeric time points.
}
\keyword{internal}
