% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_default_stats_formats_labels.R
\docType{data}
\name{default_stats_formats_labels}
\alias{default_stats_formats_labels}
\alias{get_stats}
\alias{get_formats_from_stats}
\alias{get_labels_from_stats}
\alias{get_indents_from_stats}
\alias{tern_default_stats}
\alias{tern_default_formats}
\alias{tern_default_labels}
\alias{summary_formats}
\alias{summary_labels}
\alias{summary_custom}
\title{Get default statistical methods and their associated formats, labels, and indent modifiers}
\format{
\itemize{
\item \code{tern_default_stats} is a named list of available statistics, with each element
named for their corresponding statistical method group.
}

\itemize{
\item \code{tern_default_formats} is a named vector of available default formats, with each element
named for their corresponding statistic.
}

\itemize{
\item \code{tern_default_labels} is a named \code{character} vector of available default labels, with each element
named for their corresponding statistic.
}
}
\usage{
get_stats(
  method_groups = "analyze_vars_numeric",
  stats_in = NULL,
  add_pval = FALSE
)

get_formats_from_stats(stats, formats_in = NULL)

get_labels_from_stats(stats, labels_in = NULL, row_nms = NULL)

get_indents_from_stats(stats, indents_in = NULL, row_nms = NULL)

tern_default_stats

tern_default_formats

tern_default_labels

summary_formats(type = "numeric", include_pval = FALSE)

summary_labels(type = "numeric", include_pval = FALSE)

summary_custom(
  type = "numeric",
  include_pval = FALSE,
  stats_custom = NULL,
  formats_custom = NULL,
  labels_custom = NULL,
  indent_mods_custom = NULL
)
}
\arguments{
\item{method_groups}{(\code{character})\cr indicates the statistical method group (\code{tern} analyze function)
to retrieve default statistics for. A character vector can be used to specify more than one statistical
method group.}

\item{stats_in}{(\code{character})\cr statistics to retrieve for the selected method group.}

\item{add_pval}{(\code{flag})\cr should \code{"pval"} (or \code{"pval_counts"} if \code{method_groups} contains
\code{"analyze_vars_counts"}) be added to the statistical methods?}

\item{stats}{(\code{character})\cr statistical methods to get defaults for.}

\item{formats_in}{(named \code{vector}) \cr inserted formats to replace defaults. It can be a
character vector from \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} or a custom format function.}

\item{labels_in}{(named \code{vector} of \code{character})\cr inserted labels to replace defaults.}

\item{row_nms}{(\code{character})\cr row names. Levels of a \code{factor} or \code{character} variable, each
of which the statistics in \code{.stats} will be calculated for. If this parameter is set, these
variable levels will be used as the defaults, and the names of the given custom values should
correspond to levels (or have format \code{statistic.level}) instead of statistics. Can also be
variable names if rows correspond to different variables instead of levels. Defaults to \code{NULL}.}

\item{indents_in}{(named \code{vector})\cr inserted indent modifiers to replace defaults (default is \code{0L}).}

\item{type}{(\code{flag})\cr is it going to be \code{"numeric"} or \code{"counts"}?}

\item{include_pval}{(\code{flag})\cr deprecated parameter. Same as \code{add_pval}.}

\item{stats_custom}{(\verb{named vector} of \code{character})\cr vector of statistics to include if
not the defaults. This argument overrides \code{include_pval} and other custom value arguments
such that only settings for these statistics will be returned.}

\item{formats_custom}{(\verb{named vector} of \code{character})\cr vector of custom statistics formats
to use in place of the defaults defined in \code{\link[=summary_formats]{summary_formats()}}. Names should be a subset
of the statistics defined in \code{stats_custom} (or default statistics if this is \code{NULL}).}

\item{labels_custom}{(\verb{named vector} of \code{character})\cr vector of custom statistics labels
to use in place of the defaults defined in \code{\link[=summary_labels]{summary_labels()}}. Names should be a subset
of the statistics defined in \code{stats_custom} (or default statistics if this is \code{NULL}).}

\item{indent_mods_custom}{(\code{integer} or \verb{named vector} of \code{integer})\cr vector of custom
indentation modifiers for statistics to use instead of the default of \code{0L} for all statistics.
Names should be a subset of the statistics defined in \code{stats_custom} (or default statistics
if this is \code{NULL}). Alternatively, the same indentation modifier can be applied to all
statistics by setting \code{indent_mods_custom} to a single integer value.}
}
\value{
\itemize{
\item \code{get_stats()} returns a \code{character} vector of statistical methods.
}

\itemize{
\item \code{get_formats_from_stats()} returns a named vector of formats (if present in either
\code{tern_default_formats} or \code{formats_in}, otherwise \code{NULL}). Values can be taken from
\code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} or a custom function (e.g. \link{formatting_functions}).
}

\itemize{
\item \code{get_labels_from_stats()} returns a named \code{character} vector of labels (if present in either
\code{tern_default_labels} or \code{labels_in}, otherwise \code{NULL}).
}

\itemize{
\item \code{get_indents_from_stats()} returns a single indent modifier value to apply to all rows
or a named numeric vector of indent modifiers (if present, otherwise \code{NULL}).
}

\itemize{
\item \code{summary_formats()} returns a named \code{vector} of default statistic formats for the given data type.
}

\itemize{
\item \code{summary_labels} returns a named \code{vector} of default statistic labels for the given data type.
}

\itemize{
\item \code{summary_custom} returns a \code{list} of 4 named elements: \code{stats}, \code{formats}, \code{labels},
and \code{indent_mods}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Utility functions to get valid statistic methods for different method groups
(\code{.stats}) and their associated formats (\code{.formats}), labels (\code{.labels}), and indent modifiers
(\code{.indent_mods}). This utility is used across \code{tern}, but some of its working principles can be
seen in \code{\link[=analyze_vars]{analyze_vars()}}. See notes to understand why this is experimental.
}
\details{
Current choices for \code{type} are \code{counts} and \code{numeric} for \code{\link[=analyze_vars]{analyze_vars()}} and affect \code{get_stats()}.
}
\section{Functions}{
\itemize{
\item \code{get_stats()}: Get statistics available for a given method
group (analyze function).

\item \code{get_formats_from_stats()}: Get formats corresponding to a list of statistics.

\item \code{get_labels_from_stats()}: Get labels corresponding to a list of statistics.

\item \code{get_indents_from_stats()}: Format indent modifiers for a given vector/list of statistics.

\item \code{tern_default_stats}: Named list of available statistics by method group for \code{tern}.

\item \code{tern_default_formats}: Named vector of default formats for \code{tern}.

\item \code{tern_default_labels}: Named \code{character} vector of default labels for \code{tern}.

\item \code{summary_formats()}: Quick function to retrieve default formats for summary statistics:
\code{\link[=analyze_vars]{analyze_vars()}} and \code{\link[=analyze_vars_in_cols]{analyze_vars_in_cols()}} principally.

\item \code{summary_labels()}: Quick function to retrieve default labels for summary statistics.
Returns labels of descriptive statistics which are understood by \code{rtables}. Similar to \code{summary_formats}

\item \code{summary_custom()}: \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Function to
configure settings for default or custom summary statistics for a given data type. In
addition to selecting a custom subset of statistics, the user can also set custom
formats, labels, and indent modifiers for any of these statistics.

}}
\note{
These defaults are experimental because we use the names of functions to retrieve the default
statistics. This should be generalized in groups of methods according to more reasonable groupings.

Formats in \code{tern} and \code{rtables} can be functions that take in the table cell value and
return a string. This is well documented in \code{vignette("custom_appearance", package = "rtables")}.
}
\examples{
# analyze_vars is numeric
num_stats <- get_stats("analyze_vars_numeric") # also the default

# Other type
cnt_stats <- get_stats("analyze_vars_counts")

# Weirdly taking the pval from count_occurrences
only_pval <- get_stats("count_occurrences", add_pval = TRUE, stats_in = "pval")

# All count_occurrences
all_cnt_occ <- get_stats("count_occurrences")

# Multiple
get_stats(c("count_occurrences", "analyze_vars_counts"))

# Defaults formats
get_formats_from_stats(num_stats)
get_formats_from_stats(cnt_stats)
get_formats_from_stats(only_pval)
get_formats_from_stats(all_cnt_occ)

# Addition of customs
get_formats_from_stats(all_cnt_occ, formats_in = c("fraction" = c("xx")))
get_formats_from_stats(all_cnt_occ, formats_in = list("fraction" = c("xx.xx", "xx")))

# Defaults labels
get_labels_from_stats(num_stats)
get_labels_from_stats(cnt_stats)
get_labels_from_stats(only_pval)
get_labels_from_stats(all_cnt_occ)

# Addition of customs
get_labels_from_stats(all_cnt_occ, labels_in = c("fraction" = "Fraction"))
get_labels_from_stats(all_cnt_occ, labels_in = list("fraction" = c("Some more fractions")))

get_indents_from_stats(all_cnt_occ, indents_in = 3L)
get_indents_from_stats(all_cnt_occ, indents_in = list(count = 2L, count_fraction = 5L))
get_indents_from_stats(
  all_cnt_occ,
  indents_in = list(a = 2L, count.a = 1L, count.b = 5L), row_nms = c("a", "b")
)

summary_formats()
summary_formats(type = "counts", include_pval = TRUE)

summary_labels()
summary_labels(type = "counts", include_pval = TRUE)

summary_custom()
summary_custom(type = "counts", include_pval = TRUE)
summary_custom(
  include_pval = TRUE, stats_custom = c("n", "mean", "sd", "pval"),
  labels_custom = c(sd = "Std. Dev."), indent_mods_custom = 3L
)

}
\seealso{
\link{formatting_functions}
}
\keyword{datasets}
