% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract_by_name}
\alias{extract_by_name}
\title{Extract elements by name}
\usage{
extract_by_name(x, names)
}
\arguments{
\item{x}{(named \code{vector})\cr where to extract named elements from.}

\item{names}{(\code{character})\cr vector of names to extract.}
}
\value{
\code{NULL} if \code{x} is \code{NULL}, otherwise the extracted elements from \code{x}.
}
\description{
This utility function extracts elements from a vector \code{x} by \code{names}.
Differences to the standard \code{[} function are:
}
\details{
\itemize{
\item If \code{x} is \code{NULL}, then still always \code{NULL} is returned (same as in base function).
\item If \code{x} is not \code{NULL}, then the intersection of its names is made with \code{names} and those
elements are returned. That is, \code{names} which don't appear in \code{x} are not returned as \code{NA}s.
}
}
\keyword{internal}
