% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score2adjust.R
\name{score2adjust}
\alias{score2adjust}
\title{Convert neuropsychological test scores to demographically adjusted norms.}
\usage{
score2adjust(
  data = NULL,
  test.score = NULL,
  group.id = NULL,
  control.id = NULL,
  all.controls = FALSE,
  demographics = NULL,
  mfp.alpha = 1,
  rnd.a = TRUE,
  mean.a = 50,
  sd.a = 10
)
}
\arguments{
\item{data}{a data frame containing the variables needed for the norming
process. The current version of the function does not accomodate missing
data. For best results, exclude cases with missing test scores or missing
demographics before applying this function.}

\item{test.score}{a character string specifying the name of the test to be
normed, usually the output of the \code{raw2scaled()} function.}

\item{group.id}{a character string specifying the name of the variable
containing group identification (i.e. control vs exposed/test/risk). Ignored,
if all.controls = TRUE.}

\item{control.id}{a character string specifying the label of the control
group within group.id variable. Ignored, if all.controls = TRUE.}

\item{all.controls}{a logical indicating whether all observations should be
treated as controls. Overwrites group.id and control.id.}

\item{demographics}{a single or multiple character strings (concatenated by
\code{c()} function) specifying the names of demographic predictors to be
included into normative formulas. Demographic variables should be numeric or
binary (0/1).}

\item{mfp.alpha}{a numeric value between 0 and 1 that sets significance level
for inclusion of demographic predictors into normative formula. Passed to the
\code{mfp2()} function (its \code{select} argument). Default value is 1 for
inclusion of all predictors regardless of their significance.}

\item{rnd.a}{a logical indicating whether the adjusted scores (T-scores)
should be rounded. Default is TRUE.}

\item{mean.a}{numeric value for the mean of adjusted score (T-score)
distribution. Default is 50.}

\item{sd.a}{numeric value for the standard deviation of adjusted score
(T-score) distribution. Default is 10.}
}
\value{
A list consisting of 3 objects. The first two are vectors containing the
non-adjusted test scores and the calculated demographically adjusted scores.
The last item in the output list is also a list called \code{MFP.formulas}.
It contains the information for calculation of adjusted scores, including
variable transformations (if any), multiple fractional polynomial (MFP) model
coefficients, the standard deviation of residuals resulting from the MFP
modeling, and a matrix with number of rows equal to the number of predictors
and 2 columns containing powers (in numeric form) selected for variable
transformations.
}
\description{
Convert neuropsychological test scores to demographically adjusted norms.
}
\details{
The \code{score2adjust()} function can be used by neuropsychologists, who
wish to construct normative formulas for cognitive tests that adjust for
expected effects of demographic characteristics (e.g., age), using methods
described in Heaton et al. (2003 & 2009). The adjusted scores are sometimes
referred to as T-scores in the literature. The norming procedure makes use of
the \code{mfp2()} function from the \code{mfp2} package to explore nonlinear
associations between cognition and demographic variables. Detailed
description of the procedure are found in Umlauf et al. (2024). (Previous
versions of the function depended on \code{mfp} package.)
}
\examples{
data(PsychTestData)
PsychTestData$scaledscore <- raw2scaled(data=PsychTestData, test="rawscore",
                                        test.min=0, test.max=36,
                                        test.better="High", group.id="group",
                                        control.id="control")[[2]]
score2adjust(data = PsychTestData, test.score = "scaledscore",
             group.id = "group", control.id = "control",
             demographics = c("age", "male"))
}
\references{
Umlauf A et al. (2024) Automated procedure for demographic adjustments on
cognitive test scores. <doi:10.1080/23279095.2023.2288231>

Heaton RK, Taylor MJ, & Manly J (2003) Demographic effects and use of
demographically corrected norms with the WAIS-III and WMS-III. In: Tulsky D
et al. (Eds.) \emph{Clinical Interpretation of the WAIS-III and WMS-III}.
San Diego, CA: Academic Press, 183-210.

Heaton RK, Ryan L, & Grant I (2009) Demographic influences and use of
demographically corrected norms in neuropsychological assessment. In Grant I
& Adams KM (Eds.) \emph{Neuropsychological Assessment of Neuropsychiatric
and Neuromedical Disorders}. New York, NY: Oxford University Press, 127-155.

Benner A (2005) mfp: Multivariable fractional polynomials.
\emph{R News} 5(2): 20–23.
}
\author{
Anya Umlauf
}
