% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-unique.R
\name{uniqueness-expectations}
\alias{uniqueness-expectations}
\alias{expect_unique}
\alias{expect_unique_across}
\alias{expect_unique_combine}
\title{Expectations: uniqueness}
\usage{
expect_unique(
  vars,
  exclude = getOption("testdat.miss"),
  flt = TRUE,
  data = get_testdata()
)

expect_unique_across(
  vars,
  exclude = getOption("testdat.miss"),
  flt = TRUE,
  data = get_testdata()
)

expect_unique_combine(
  vars,
  exclude = getOption("testdat.miss"),
  flt = TRUE,
  data = get_testdata()
)
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{exclude}{a vector of values to exclude from uniqueness check.  The
\link[=testdat]{testdat.miss} option is used by default. To include all values,
set \code{exclude = NULL}.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
These functions test variables for uniqueness.
}
\details{
\itemize{
\item \code{expect_unique()} tests a set of columns (\code{vars}) and fails if the combined
columns do not uniquely identify each row.
\item \code{expect_unique_across()} tests a set of columns (\code{vars}) and fails if each
row does not have unique values in each column.
\item \code{expect_unique_combine()} tests a set of columns (\code{vars}) and fails if any
value appears more than once across all of them.
}

By default the uniqueness check excludes missing values (as specified by the
\link[=testdat]{testdat.miss} option). Setting \code{exclude = NULL} will include all
values.
}
\examples{

student_fruit_preferences <- data.frame(
  student_id = c(1:5, NA, NA),
  apple = c(1, 1, 1, 1, 99, NA, NA),
  orange = c(2, 3, 2, 3, 99, NA, NA),
  banana = c(3, 2, 3, 2, 99, NA, NA),
  phone1 = c(123, 456, 789, 987, 654, NA, NA),
  phone2 = c(345, 678, 987, 567, 000, NA, NA)
)

# Check that key is unique, excluding NAs by default
expect_unique(student_id, data = student_fruit_preferences)

# Check that key is unique, including NAs
try(expect_unique(student_id, exclude = NULL, data = student_fruit_preferences))

# Check each fruit has unique preference number
try(
expect_unique_across(
  c(apple, orange, banana),
  data = student_fruit_preferences
)
)

# Check each fruit has unique preference number, allowing multiple 99 (item
# skipped) codes
expect_unique_across(
  c(apple, orange, banana),
  exclude = c(99, NA), data = student_fruit_preferences
)

# Check that each phone number appears at most once
try(expect_unique_combine(c(phone1, phone2), data = student_fruit_preferences))

}
\seealso{
\link[=chk-uniqueness]{Checks: uniqueness}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
