% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-conditional.R
\name{conditional-expectations}
\alias{conditional-expectations}
\alias{expect_cond}
\alias{expect_base}
\title{Expectations: consistency}
\usage{
expect_cond(cond1, cond2, data = get_testdata())

expect_base(
  var,
  base,
  miss = getOption("testdat.miss"),
  missing_valid = FALSE,
  data = get_testdata()
)
}
\arguments{
\item{cond1}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> First condition
(antecedent) for consistency check.}

\item{cond2}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Second condition
(consequent) for consistency check.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{var}{An unquoted column name to test.}

\item{base}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> The condition that
determines which records should be non-missing.}

\item{miss}{A vector of values to be treated as missing. The
\link[=testdat]{testdat.miss} option is used by default.}

\item{missing_valid}{Should missing values be treated as valid for records
meeting the \code{base} condition? This allows 'one way' base checks. This is
\code{FALSE} by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
These functions test whether multiple conditions coexist.
}
\section{Functions}{
\itemize{
\item \code{expect_cond()}: Checks the coexistence of two
conditions. It can be read as "if \code{cond1} then \code{cond2}".

\item \code{expect_base()}: A special case that checks missing data
against a specified condition. It can be read as "if \code{base} then \code{var} not
missing, if not \code{base} then \code{var} missing".

}}
\examples{
my_survey <- data.frame(
  resp_id = 1:5,
  q1a = c(0, 1, 0, 1, 0),
  q1b = c(NA, NA, NA, 1, 0), # Asked if q1a \%in\% 1
  q2a = c(90, 80, 60, 40, 90),
  q2b = c("", "", NA, "Some reason for low rating", "") # Asked if q2a < 50
)

# Check that q1b has a value if and only if q1a \%in\% 1
try(expect_base(q1b, q1a \%in\% 1, data = my_survey)) # Fails for resp_id 2 and 5

# Check that q2b has a value if and only if q2a < 50
expect_base(q2b, q2a < 50, data = my_survey)

# Check that if q1a \%in\% 0 then q2a > 50 (but not vice-versa)
expect_cond(q1a \%in\% 0, q2a > 50, data = my_survey)

}
\seealso{
Other data expectations: 
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{expect_depends}()},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
