% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strings.R
\name{string-tests}
\alias{string-tests}
\alias{is_nonempty_string}
\alias{is_optional_string}
\title{Tests for strings}
\usage{
is_nonempty_string(x)

is_optional_string(x)
}
\arguments{
\item{x}{a character vector/string.}
}
\description{
Tests for strings
}
\section{Functions}{
\itemize{
\item \code{is_nonempty_string}: Test that a character is both a string (character vector of length one)
and that it is non-empty, has at least one character and is not missing.

\item \code{is_optional_string}: Check for an optional string: must be a character, not missing,
a vector of either length 0 or 1, and if provided must not be empty ("").
}}

\examples{
# TRUE
is_nonempty_string("hello")

# All FALSE
x <- c("hello", "world")
is_nonempty_string(x)
is_nonempty_string(NA_character_)
is_nonempty_string(character(0))
is_nonempty_string(NULL)
is_nonempty_string(12345)
}
