% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expectations.r
\name{expect-compare}
\alias{expect-compare}
\alias{expect_less_than}
\alias{expect_more_than}
\title{Expectation: is returned value less or greater than specified value?}
\usage{
expect_less_than(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)

expect_more_than(object, expected, ..., info = NULL, label = NULL,
  expected.label = NULL)
}
\arguments{
\item{object}{object to test}

\item{expected}{Expected value}

\item{...}{other values passed to \code{\link{all.equal}}}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{For full form, label of expected object used in error
messages. Useful to override default (deparsed expected expression) when
doing tests in a loop.  For short cut form, object label. When
\code{NULL}, computed from deparsed object.}

\item{expected.label}{Equivalent of \code{label} for shortcut form.}
}
\description{
This is useful for ensuring returned value is below a ceiling or above
a floor.
}
\examples{
a <- 9
expect_less_than(a, 10)

\dontrun{
expect_less_than(11, 10)
}

a <- 11
expect_more_than(a, 10)
\dontrun{
expect_more_than(9, 10)
}
}
\seealso{
Other expectations: \code{\link{equivalence}},
  \code{\link{expect_equal}},
  \code{\link{expect_equivalent}},
  \code{\link{expect_identical}};
  \code{\link{expect_equal_to_reference}};
  \code{\link{expect_error}}, \code{\link{expect_match}},
  \code{\link{expect_message}},
  \code{\link{expect_output}},
  \code{\link{expect_warning}},
  \code{\link{matching-expectations}};
  \code{\link{expect_false}}, \code{\link{expect_true}};
  \code{\link{expect_is}}; \code{\link{expect_named}};
  \code{\link{expect_null}}; \code{\link{takes_less_than}}
}

