% Generated by roxygen2 (4.0.1): do not edit by hand
\name{assert}
\alias{assert}
\title{Explicitly state that we expect no errors to occur.}
\usage{
assert(expr, ...)
}
\arguments{
\item{expr}{expression. This expression should not error.}

\item{...}{additional arguments to \code{expect_false}, like \code{info}.}
}
\description{
Note we could simply write the expression itself and let it error,
but using \code{assert} makes the intention of the code clearer
(like using \code{base::force}).
}
\details{
For testing the converse, there already is \code{expect_error}.
}
\examples{
assert(1 + 1) # This will throw no error.
stopifnot(is(tryCatch(error = identity, assert(not_existent)), 'error'))
# The above will produce an error. In unit tests, it will be clear this
# means "We expect no error to occur."
}

