% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{plotreg}
\alias{plotreg}
\title{Create coefficient plots from statistical model output using \pkg{ggplot2}.}
\usage{
plotreg(
  l,
  file = NULL,
  custom.model.names = NULL,
  custom.title = NULL,
  custom.coef.names = NULL,
  custom.coef.map = NULL,
  custom.note = NULL,
  override.coef = 0,
  override.se = 0,
  override.pval = 0,
  override.ci.low = 0,
  override.ci.up = 0,
  override.pvalues = 0,
  omit.coef = NULL,
  reorder.coef = NULL,
  ci.level = 0.95,
  ci.force = FALSE,
  ci.force.level = 0.95,
  ci.test = 0,
  type = "facet",
  theme = NULL,
  signif.light = "#FBC9B9",
  signif.medium = "#F7523A",
  signif.dark = "#BD0017",
  insignif.light = "#C5DBE9",
  insignif.medium = "#5A9ECC",
  insignif.dark = "#1C5BA6",
  ...
)
}
\arguments{
\item{l}{A statistical model or a list of statistical models. Lists of
models can be specified as \code{l = list(model.1, model.2, ...)}.
Different object types can also be mixed.}

\item{file}{Using this argument, the resulting table is written to a file
rather than to the \R prompt. The file name can be specified as a character
string. Writing a table to a file can be useful for working with MS Office
or LibreOffice. For example, using the \code{\link{htmlreg}} function, an
HTML table can be written to a file with the extension \code{.doc} and
opened with MS Word. The table can then be simply copied into any Word
document, retaining the formatting of the table. Note that LibreOffice can
import only plain HTML; CSS decorations are not supported; the resulting
tables do not retain the full formatting in LibreOffice.}

\item{custom.model.names}{A character vector of labels for the models. By
default, the models are named "Model 1", "Model 2", etc. Specifying
\code{model.names = c("My name 1", "My name 2")} etc. overrides the default
behavior.}

\item{custom.title}{With this argument, a replacement text for the
\code{ggtitle}, which provides a title above the diagram, can be provided.
If an empty character object is provided (\code{custom.title = ""}), the
title will be omitted completely.}

\item{custom.coef.names}{By default, \pkg{texreg} uses the coefficient names
  which are stored in the models. The \code{custom.coef.names} argument can
  be used to replace them by other character strings in the order of
  appearance. For example, if a table shows a total of three different
  coefficients (including the intercept), the argument
  \code{custom.coef.names = c("Intercept", "variable 1", "variable 2")} will
  replace their names in this order.

  Sometimes it happens that the same variable has a different name in
  different models. In this case, the user can use this function to assign
  identical names. If possible, the rows will then be merged into a single
  row unless both rows contain values in the same column.

  Where the argument contains an \code{NA} value, the original name of the
  coefficient is kept. For example, \code{custom.coef.names = c(NA, "age",
  NA)} will only replace the second coefficient name and leave the first and
  third name as they are in the original model.

  See also \code{custom.coef.map} for an easier and more comprehensive way to
  rename, omit, and reorder coefficients.}

\item{custom.coef.map}{The \code{custom.coef.map} argument can be used to
  select, omit, rename, and reorder coefficients.

  Users must supply a named list of this form: \code{list("x" = "First
  variable", "y" = NA, "z" = "Third variable")}. With that particular example
  of \code{custom.coef.map},
  \enumerate{
   \item coefficients will be presented in order: \code{"x"}, \code{"y"},
     \code{"z"}.
   \item variable \code{"x"} will appear as \code{"First variable"}, variable
     \code{"y"} will appear as \code{"y"}, and variable \code{"z"} will
     appear as "Third variable".
   \item all variables not named \code{"x"}, \code{"y"}, or \code{"z"} will
     be omitted from the table.
  }}

\item{custom.note}{With this argument, a replacement text for the
  significance note below the table can be provided. If an empty
  \code{character} object is provided (\code{custom.note = ""}), the note
  will be omitted completely. If some character string is provided (e.g.,
  \code{custom.note = "My note"}), the significance legend is replaced by
  \code{My note}. The original significance legend can be included by
  inserting the \code{\%stars} wildcard. For example, a custom note can be
  added right after the significance legend by providing \code{custom.note =
  "\%stars. My note."}.

  If the \code{threeparttable} argument is used, any note should be preceded
  by \code{"\\\\item"}, for example
  \code{"\\\\item \%stars. \\\\item Second note. \\\\item Third note."}, and
  it is possible to create line breaks in the formatted table by including
  \code{"\\\\\\\\"} and line breaks in the LaTeX code by including
  \code{"\\n"}, for example
  \code{"\\n\\\\item \%stars.\\\\\\\\\\n\\\\item Second line.\\n"}.}

\item{override.coef}{Set custom values for the coefficients. New coefficients
are provided as a list of numeric vectors. The list contains vectors of
coefficients for each model. There must be as many vectors of coefficients
as there are models. For example, if there are two models with three model
terms each, the argument could be specified as \code{override.coef =
list(c(0.1, 0.2, 0.3), c(0.05, 0.06, 0.07))}. If there is only one model,
custom values can be provided as a plain vector (not embedded in a list).
For example: \code{override.coef = c(0.05, 0.06, 0.07)}.}

\item{override.se}{Set custom values for the standard errors. New standard
errors are provided as a list of numeric vectors. The list contains vectors
of standard errors for each model. There must be as many vectors of
standard errors as there are models. For example, if there are two models
with three coefficients each, the argument could be specified as
\code{override.se = list(c(0.1, 0.2, 0.3), c(0.05, 0.06, 0.07))}. If there
is only one model, custom values can be provided as a plain vector (not
embedded in a list).For example: \code{override.se = c(0.05, 0.06, 0.07)}.
Overriding standard errors can be useful for the implementation of robust
SEs, for example.}

\item{override.pval}{Set custom values for the p-values. New p-values are
provided as a list of numeric vectors. The list contains vectors of
p-values for each model. There must be as many vectors of p-values as there
are models. For example, if there are two models with three coefficients
each, the argument could be specified as \code{override.pvalues =
list(c(0.1, 0.2, 0.3), c(0.05, 0.06, 0.07))}. If there is only one model,
custom values can be provided as a plain vector (not embedded in a list).
For example: \code{override.pvalues = c(0.05, 0.06, 0.07)}. Overriding
p-values can be useful for the implementation of robust SEs and p-values,
for example.}

\item{override.ci.low}{Set custom lower confidence interval bounds. This
works like the other override arguments, with one exception: if confidence
intervals are provided here and in the \code{override.ci.up} argument, the
standard errors and p-values as well as the \code{ci.force} argument are
ignored.}

\item{override.ci.up}{Set custom upper confidence interval bounds. This
works like the other override arguments, with one exception: if confidence
intervals are provided here and in the \code{override.ci.low} argument, the
standard errors and p values as well as the \code{ci.force} argument are
ignored.}

\item{override.pvalues}{Set custom values for the p-values. New p-values are
provided as a list of numeric vectors. The list contains vectors of
p-values for each model. There must be as many vectors of p-values as there
are models. For example, if there are two models with three coefficients
each, the argument could be specified as \code{override.pvalues =
list(c(0.1, 0.2, 0.3), c(0.05, 0.06, 0.07))}. If there is only one model,
custom values can be provided as a plain vector (not embedded in a list).
For example: \code{override.pvalues = c(0.05, 0.06, 0.07)}. Overriding
p-values can be useful for the implementation of robust SEs and p-values,
for example.}

\item{omit.coef}{A character string which is used as a regular expression to
remove coefficient rows from the table. For example, \code{omit.coef =
"group"} deletes all coefficient rows from the table where the name of the
coefficient contains the character sequence \code{"group"}. More complex
regular expressions can be used to filter out several kinds of model terms,
for example \code{omit.coef = "(thresh)|(ranef)"} to remove all model terms
matching either \code{"thresh"} or \code{"ranef"}. The \code{omit.coef}
argument is processed after the \code{custom.coef.names} argument, so the
regular expression should refer to the custom coefficient names. To omit
GOF entries instead of coefficient entries, use the custom arguments of the
extract functions instead (see the help entry of the \code{\link{extract}}
function.}

\item{reorder.coef}{Reorder the rows of the coefficient block of the
resulting table in a custom way. The argument takes a vector of the same
length as the number of coefficients. For example, if there are three
coefficients, \code{reorder.coef = c(3, 2, 1)} will put the third
coefficient in the first row and the first coefficient in the third row.
Reordering can be sensible because interaction effects are often added to
the end of the model output although they were specified earlier in the
model formula. Note: Reordering takes place after processing custom
coefficient names and after omitting coefficients, so the
\code{custom.coef.names} and \code{omit.coef} arguments should follow the
original order.}

\item{ci.level}{If standard errors are converted to confidence intervals
(because a model does not natively support CIs), what confidence level
should be used for the outer confidence interval? By default, \code{0.95}
is used (i.e., an alpha value of 0.05).}

\item{ci.force}{Should confidence intervals be used instead of the default
standard errors and p-values? Most models implemented in the \pkg{texreg}
package report standard errors and p-values by default while few models
report confidence intervals. However, the functions in the \pkg{texreg}
package can convert standard errors and into confidence intervals using
z-scores if desired. To enforce confidence intervals instead of standard
errors, the \code{ci.force} argument accepts either a logical value
indicating whether all models or none of the models should be forced to
report confidence intervals (\code{ci.force = TRUE} for all and
\code{ci.force = FALSE} for none) or a vector of logical values indicating
for each model separately whether the model should be forced to report
confidence intervals (e.g., \code{ci.force = c(FALSE, TRUE, FALSE)}).
Confidence intervals are computed using the standard normal distribution
(z-values based on the \code{\link[stats:Normal]{qnorm}} function). The
t-distribution is currently not supported because this would require each
\code{\link{extract}} method to have an additional argument for the degrees
of freedom.}

\item{ci.force.level}{If the \code{ci.force} argument is used to convert
standard errors to confidence intervals, what confidence level should be
used? By default, \code{0.95} is used (i.e., an alpha value of 0.05).}

\item{ci.test}{If confidence intervals are reported, the \code{ci.test}
argument specifies the reference value to establish whether a
coefficient/CI is significant. The default value \code{ci.test = 0}, for
example, will display coefficients with a round circle and the red color
if the confidence interval does not contain \code{0}. A value of
\code{ci.test = 1} could be useful if coefficients are provided on the
odds-ratio scale, for example. It is possible to provide a single value
for all models or a vector with a separate value for each model
(even if it would make the plot hard to read). The \code{ci.test} argument
 works both for models with native support for confidence intervals and
 in cases where the \code{ci.force} argument is used.}

\item{type}{The default option is \code{type = "facet"}. If only one model is
specified, it will print one forest plot applied to point estimates and
confidence intervals. If more than one model is specified, it will print
as many facets as the number of models in a column of plots. Alternatively,
if \code{type = "forest"} is specified, coefficients from one or more
models will be grouped together and displayed as a single forest plot.}

\item{theme}{The \code{theme} argument can be used to customize the
appearance of the plot. The default theme is \code{theme_bw}. It can be
replaced by any other \pkg{ggplot2} theme. See
\code{\link[ggplot2]{ggtheme}} for details.}

\item{signif.light}{Color of outer confidence intervals for significant model
terms.}

\item{signif.medium}{Color of inner confidence intervals for significant
model terms.}

\item{signif.dark}{Color of point estimates and labels for significant model
terms.}

\item{insignif.light}{Color of outer confidence intervals for insignificant
model terms.}

\item{insignif.medium}{Color of inner confidence intervals for insignificant
model terms.}

\item{insignif.dark}{Color of point estimates and labels for insignificant
model terms.}

\item{...}{Custom options to be passed on to the \code{\link{extract}}
function. For example, most extract methods provide custom options for the
inclusion or exclusion of specific goodness-of-fit statistics. See the help
entries of \code{\link{extract}} for more information.}
}
\value{
Coefficient plot as a \pkg{ggplot2} \code{gg} object if
  \code{file = FALSE}. \code{NULL} otherwise.
}
\description{
Create coefficient plots of \R regression output using \pkg{ggplot2}.
}
\details{
The \code{plotreg} function produces coefficient plots (i.e., forest plots
applied to point estimates and confidence intervals) and works much like the
\code{\link{screenreg}}, \code{\link{texreg}}, \code{\link{htmlreg}},
\code{\link{matrixreg}} and \code{\link{wordreg}} functions. It accepts a
single model or multiple statistical models as input and internally extracts
the relevant data from the models. If confidence intervals are not defined in
the extract method of a statistical model (see \link{extract}), the default
standard errors are converted to confidence intervals. Most of the arguments
work like in the \code{\link{screenreg}}, \code{\link{texreg}}, and
\code{\link{htmlreg}} \code{\link{matrixreg}}, and \code{\link{wordreg}}
functions. It is possible to display the plots in two ways: using the
\code{type = "facet"} argument, one forest plot applied to point estimates
and confidence intervals will be visualized in case there is only one model.
If there is more than one model, each one will be plotted next to the other
as a separate facet; using the \code{type = "forest"} argument, coefficients
from one or more models will be grouped together and displayed as a single
forest plot.
}
\examples{
\dontrun{
# example from the 'lm' help file:
ctl <- c(4.17, 5.58, 5.18, 6.11, 4.50, 4.61, 5.17, 4.53, 5.33, 5.14)
trt <- c(4.81, 4.17, 4.41, 3.59, 5.87, 3.83, 6.03, 4.89, 4.32, 4.69)
group <- gl(2, 10, 20, labels = c("Ctl", "Trt"))
weight <- c(ctl, trt)
lm.D9 <- lm(weight ~ group)
lm.D90 <- lm(weight ~ group - 1)
plotreg(lm.D9) # plot model output as a diagram

# customize theme and title and save as a PDF file.
plotreg(lm.D9,
        theme = theme_dark(),
        ggtitle = "my title",
        file = "myplot.pdf")
unlink("myplot.pdf")

# group coefficients from multiple models
plotreg(list(lm.D9, lm.D90), type = "forest")
}

}
\seealso{
\code{\link{texreg-package}} \code{\link{extract}}
  \code{\link{texreg}} \code{\link{matrixreg}}

Other texreg: 
\code{\link{htmlreg}()},
\code{\link{huxtablereg}()},
\code{\link{knitreg}()},
\code{\link{matrixreg}()},
\code{\link{screenreg}()},
\code{\link{texreg}},
\code{\link{wordreg}()}
}
\author{
Claudia Zucca, Philip Leifeld
}
\concept{texreg}
