% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformers.R
\name{transform_tf}
\alias{transform_binary}
\alias{transform_tf}
\alias{transform_tfidf}
\title{Scale a document-term matrix}
\usage{
transform_tf(dtm, sublinear_tf = FALSE, norm = c("l1", "l2"))

transform_tfidf(dtm, idf = NULL, sublinear_tf = FALSE, norm = c("l1",
  "l2"))

transform_binary(dtm)
}
\arguments{
\item{dtm}{a document-term matrix of class \code{dgCMatrix} or
\code{dgTMatrix}.}

\item{sublinear_tf}{\code{logical}, \code{FALSE} by default. Apply sublinear
term-frequency scaling, i.e., replace the term frequency with \code{1 +
log(TF)}.}

\item{norm}{\code{character} Type of normalization to apply to term vectors.
\code{"l1"} by default, i.e., scale by the number of words in the document.}

\item{idf}{\code{ddiMatrix} a diagonal matrix for IDF scaling. See
\link{get_idf}. If not provided the IDF scaling matrix will be calculated
from the matrix passed to \code{dtm}.}
}
\description{
This set of functions scales a document-term matrix.

\code{transform_tf}: scale a DTM by one of two methods. If \code{norm =
"l1"}, then then \code{dtm_tf = (count of a particular word in the document)
/ (total number of words in the document)}. If \code{norm = "l2"}, then
\code{dtm_tf = (count of a particular word in the document) ^ 2 / (total
number words in the document) ^ 2}.

\code{transform_binary}: scale a DTM so that if a cell is 1 if a word appears
in the document; otherwise it is 0.

\code{transform_tfidf}: scale a DTM so that \code{dtm_idf = log(count of a
particular word in a document) / (number of documents where the term appears
+ 1)}
}
\section{Functions}{
\itemize{
\item \code{transform_tfidf}: Scale a document-term matrix via TF-IDF

\item \code{transform_binary}: Transform a document-term matrix into binary
representation
}}
\examples{
\dontrun{
data(moview_review)

txt <- movie_review[['review']][1:1000]
it <- itoken(txt, tolower, word_tokenizer)
vocab <- vocabulary(it)
#remove very common and uncommon words
pruned_vocab = prune_vocabulary(vocab,
 term_count_min = 10,
 doc_proportion_max = 0.8, doc_proportion_min = 0.001,
 max_number_of_terms = 20000)

it <- itoken(txt, tolower, word_tokenizer)
dtm <- create_dtm(it, pruned_vocab)

dtm_filtered <- dtm \%>\%
 # functionality overlaps with prune_vocabulary(),
 # but still can be useful in some cases
 # filter out very common and very uncommon terms
 transform_filter_commons( c(0.001, 0.975) )

# simple term-frequency transormation
transformed_tf <- dtm \%>\%
 transform_tf

# tf-idf transormation
idf <- get_idf(dtm)
transformed_tfidf <- transform_tfidf(dtm,  idf)
}
}
\seealso{
\link{get_idf}, \link{get_tf}
}

