% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_html.R
\name{replace_html}
\alias{replace_html}
\title{Replace HTML Markup}
\usage{
replace_html(x, symbol = TRUE, ...)
}
\arguments{
\item{x}{The text variable.}

\item{symbol}{logical.  If code{TRUE} the symbols are retained with appropriate
replacements.  If \code{FALSE} they are removed.}

\item{\ldots}{Ignored.}
}
\value{
Returns a vector with HTML markup replaced.
}
\description{
Replaces HTML markup.  The angle braces are removed and the HTML symbol 
markup is replaced with equivalent symbols.
}
\details{
Replacements for symbols are as follows:

\tabular{lr}{
 \bold{html} \tab  \bold{symbol} \cr
  &copy;   \tab (c) \cr
  &reg;   \tab (r) \cr
  &trade;   \tab tm \cr
  &ldquo;   \tab " \cr
  &rdquo;   \tab " \cr
  &lsquo;   \tab ' \cr
  &rsquo;   \tab ' \cr
  &bull;   \tab - \cr
  &middot;   \tab - \cr
  &sdot;   \tab [] \cr
  &ndash;   \tab - \cr
  &mdash;   \tab - \cr
  &cent;   \tab cents \cr
  &pound;   \tab pounds \cr
  &euro;   \tab euro \cr
  &ne;   \tab != \cr
  &frac12;   \tab half \cr
  &frac14;   \tab quarter \cr
  &frac34;   \tab three fourths \cr
  &deg;   \tab degrees \cr
  &larr;   \tab <- \cr
  &rarr;   \tab -> \cr
  &hellip;   \tab ... \cr
  &nbsp;   \tab   \cr
  &lt;   \tab < \cr
  &gt;   \tab > \cr
  &amp;   \tab & \cr
  &quot;   \tab " \cr
  &apos;   \tab ' \cr
  &yen;   \tab yen \cr
}
}
\examples{
x <- c(
    "<bold>Random</bold> text with symbols: &nbsp; &lt; &gt; &amp; &quot; &apos;",
    "<p>More text</p> &cent; &pound; &yen; &euro; &copy; &reg;"
)

replace_html(x)
replace_html(x, FALSE)
replace_white(replace_html(x, FALSE))
}
\keyword{html}
