% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcTopicModelR2.R
\name{CalcTopicModelR2}
\alias{CalcTopicModelR2}
\title{Function to calculate R-squared of a topic model.}
\usage{
CalcTopicModelR2(dtm, phi, theta)
}
\arguments{
\item{dtm}{A documents by terms dimensional document term matrix of class
\code{dgCMatrix} or of class \code{matrix}.}

\item{phi}{A topics by terms dimensional matrix where each entry is p(term_i |topic_j)}

\item{theta}{A documents by topics dimensional matrix where each entry is p(topic_j|document_d)}
}
\value{
Returns an object of class \code{numeric} representing the proportion of variability
in the data that is explained by the topic model.
}
\description{
Function to calculate R-squared for a topic model. 
This uses a geometric interpretation of R-squared as the proportion of total distance 
each document is from the center of all the documents that is explained by the model.
}
\note{
Will *not* work on DTMs from the \code{tm} package or simple triplet matrices from 
the \code{slam} package.
}
\examples{
# Load a pre-formatted dtm and topic model
data(acq2) 

# Get the R-squared of the model
r2 <- CalcTopicModelR2(dtm = dtm, phi = model$phi, theta = model$theta)

r2
}

