% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTopTerms.R
\name{GetTopTerms}
\alias{GetTopTerms}
\title{Get Top Terms for each topic from a topic model}
\usage{
GetTopTerms(phi, M)
}
\arguments{
\item{phi}{A matrix whose rows index topics and columns index words}

\item{M}{An integer for the number of terms to return}
}
\value{
Returns a \code{data.frame} whose columns correspond to a topic and
whose m-th row correspond to the m-th top term from the input \code{phi}.
}
\description{
Takes topics by terms matrix and returns top M terms for each topic
}
\examples{
# Load a pre-formatted dtm and topic model
data(nih_sample_dtm)
data(nih_sample_topic_model) 

top_terms <- GetTopTerms(phi = nih_sample_topic_model$phi, M = 5)

str(top_terms)
}

